function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/Severity
 */
define([], function () {
  'use strict';
  /**
   * Class representing a configured severity level, e.g. "caution" or
   * "critical".
   *
   * @class
   * @alias module:nmodule/nss/rc/model/Severity
   * @param {object} params
   * @param {string} [params.displayName=params.name] severity display name
   * @param {string[]} [params.icon=[]] array of strings that define an icon
   * for this severity level
   * @param {string} params.name severity name
   * @param {number} params.priority severity priority
   * @throws {Error} if name or priority is missing
   */

  return /*#__PURE__*/function () {
    function Severity() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          displayName = _ref.displayName,
          icon = _ref.icon,
          name = _ref.name,
          priority = _ref.priority;

      _classCallCheck(this, Severity);

      if (typeof name !== 'string') {
        throw new Error('name required');
      }

      if (typeof priority !== 'number') {
        throw new Error('priority required');
      }

      this.$displayName = displayName || name;
      this.$icon = icon || [];
      this.$name = name;
      this.$priority = priority;
    }
    /**
     * @returns {string} severity display name
     */


    _createClass(Severity, [{
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }
      /**
       * @returns {string[]} severity icon
       */

    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }
      /**
       * @returns {string} severity name
       */

    }, {
      key: "getName",
      value: function getName() {
        return this.$name;
      }
      /**
       * @returns {number} severity priority
       */

    }, {
      key: "getPriority",
      value: function getPriority() {
        return this.$priority;
      }
    }]);

    return Severity;
  }();
});
