function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Karthik Harpanhalli
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/ItemCollection
 */
define(['nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Item', 'nmodule/nss/rc/model/Severity', 'nmodule/nss/rc/util/securityDashboardUtil', 'nmodule/webEditors/rc/mixin/DataMixin', 'lex!nss'], function (Entity, Item, Severity, securityDashboardUtil, DataMixin, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      nssLex = _lexs[0];
  /**
   * @private
   * @param {module:nmodule/nss/rc/model/Severity[]} [severities]
   * @returns {boolean}
   */


  function isArrayOfSeverities(severities) {
    if (Array.isArray(severities)) {
      for (var i = 0; i <= severities.length - 1; i++) {
        if (!(severities[i] instanceof Severity)) {
          return false;
        }
      }
    } else {
      return false;
    }

    return true;
  }
  /**
   * @private
   * @param {module:nmodule/nss/rc/model/Severity[]} severities
   * @param {module:nmodule/nss/rc/model/Item[]} sortedItems, sorted items by Severity
   * @returns {module:nmodule/nss/rc/model/Item[]} returned items after sorting as per the order
   */


  function processSeverities(severities, sortedItems) {
    var severitiesToQuery = [];
    var itemsToReturn = [];
    severities.forEach(function (severity) {
      if (severitiesToQuery.indexOf(severity.getName()) === -1) {
        severitiesToQuery.push(severity.getName());
      }
    });
    var uniqueSortedSeverityNames = [];
    sortedItems.forEach(function (item) {
      if (uniqueSortedSeverityNames.indexOf(item.getSeverity().getName()) === -1) {
        uniqueSortedSeverityNames.push(item.getSeverity().getName());
      }
    });
    uniqueSortedSeverityNames.forEach(function (name) {
      if (severitiesToQuery.indexOf(name) !== -1) {
        var filteredItems = securityDashboardUtil.filterBySeverityName(sortedItems, name);
        itemsToReturn = itemsToReturn.concat(filteredItems);
      }
    });
    return itemsToReturn;
  }
  /**
   * A collection of security dashboard items from one individual source, such
   * as a UserService, or one station in a supervisor rollup.
   *
   * @class
   * @alias module:nmodule/nss/rc/model/ItemCollection
   * @mixes module:nmodule/webEditors/rc/mixin/DataMixin
   * @param {object} params
   * @param {module:nmodule/nss/rc/model/Entity} params.entity source entity for list of Item
   * @param {module:nmodule/nss/rc/model/Item[]} [params.items=[]] list of items of type Item, default will be an empty array
   * @param {Date | null} [params.timestamp=null] should be null if generated from a station; returns Date if generated from a supervisor rollup
   * @throws {Error} if items, entity, or timestamp are missing
   */


  return /*#__PURE__*/function () {
    function ItemCollection() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          entity = _ref.entity,
          _ref$items = _ref.items,
          items = _ref$items === void 0 ? [] : _ref$items,
          _ref$timestamp = _ref.timestamp,
          timestamp = _ref$timestamp === void 0 ? null : _ref$timestamp;

      _classCallCheck(this, ItemCollection);

      if (!(entity instanceof Entity)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.entity.required.error'));
      }

      if (!this.$isValidItemList(items)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.items.required.error'));
      }

      if (!(timestamp === null || timestamp instanceof Date)) {
        throw new Error(nssLex.get('SecurityDashboardView.itemCollection.date.invalid'));
      }

      this.$items = items || [];
      this.$entity = entity;
      this.$timestamp = timestamp;
      DataMixin(this, {
        status: ItemCollection.status.COMPLETE
      });
    }

    _createClass(ItemCollection, [{
      key: "$isValidItemList",

      /**
       * @private
       * @param {module:nmodule/nss/rc/model/Item[]} itemsList is list of items of type Item
       * @returns {boolean} true if itemList is valid and false on invalid
       */
      value: function $isValidItemList(itemsList) {
        if (itemsList) {
          if (Array.isArray(itemsList)) {
            return itemsList.every(function (item) {
              return item instanceof Item;
            });
          } else {
            return false;
          }
        }

        return true;
      }
      /**
       * @returns {module:nmodule/nss/rc/model/Entity} Entity related to all the
       * items in the itemsList
       */

    }, {
      key: "getSourceEntity",
      value: function getSourceEntity() {
        return this.$entity;
      }
      /**
       * @param {module:nmodule/nss/rc/model/Severity[]} severities is optional,
       * pass in optional array of Severity
       * @returns {module:nmodule/nss/rc/model/Item[]} after sorting
       * objects to get items that only match the Severities,
       * sort results by Severity, highest first
       */

    }, {
      key: "getItems",
      value: function getItems(severities) {
        var allItems = this.$items;
        var sortedItems = securityDashboardUtil.sortByPriority(allItems);

        if (severities) {
          if (isArrayOfSeverities(severities)) {
            return processSeverities(severities, sortedItems);
          } else {
            return [];
          }
        } else {
          return sortedItems;
        }
      }
      /**
       * @returns {number} total count of items
       */

    }, {
      key: "getItemCount",
      value: function getItemCount() {
        return this.$items.length;
      }
      /**
       * @returns {Object[]} severityMapObject - where each entry has a Severity object to give
       * the severity details like, icon, name and display name, and count property says the count
       * of severities, and returns empty array when there are no Item in the list.
       */

    }, {
      key: "getCountsBySeverity",
      value: function getCountsBySeverity() {
        var _this = this;

        var allItems = securityDashboardUtil.sortByPriority(this.$items);
        var uniqueSeveritiesName = [];
        var severityMapObject = [];
        allItems.forEach(function (item) {
          var severityName = item.getSeverity().getName();

          if (uniqueSeveritiesName.indexOf(severityName) === -1) {
            uniqueSeveritiesName.push(severityName);
            severityMapObject.push(_this.$getSeverityReferenceAndCount(item.getSeverity()));
          }
        });
        return severityMapObject;
      }
      /**
       * @param {module:nmodule/nss/rc/model/Severity} severityObj the criteria to filter by priority
       * @returns {Object} count based on severities
       */

    }, {
      key: "$getSeverityReferenceAndCount",
      value: function $getSeverityReferenceAndCount(severityObj) {
        var allItems = this.$items;
        var filteredItems = securityDashboardUtil.filterBySeverity(allItems, severityObj);
        return {
          severity: filteredItems[0].getSeverity(),
          count: filteredItems.length
        };
      }
      /**
       * @returns {Severity | undefined } the maximum Severity in the total list of Items
       * or undefined, if there are no Item in the itemList
       */

    }, {
      key: "getMaxSeverity",
      value: function getMaxSeverity() {
        if (this.$items.length > 0) {
          var allItems = this.$items;
          var sortedItems = securityDashboardUtil.sortByPriority(allItems);
          return sortedItems[0].getSeverity();
        }
      }
      /**
       * @returns {Date | null} the timestamp at which this collection of items was generated
       */

    }, {
      key: "getTimestamp",
      value: function getTimestamp() {
        return this.$timestamp;
      }
    }], [{
      key: "status",
      get: function get() {
        /**
         * Enumerated status of an individual ItemCollection. In a system view,
         * ItemCollections come from individual stations, which can go down or take
         * a while to return results. In the case of PENDING the UI may want to
         * wait a bit and then poll again until the ItemCollection comes back
         * COMPLETE.
         *
         * @private
         * @readonly
         * @enum
         * @name module:nmodule/nss/rc/model/ItemCollection.status
         */
        return {
          /** Item collection has a complete set of data from the server and fit for display. */
          COMPLETE: 'COMPLETE',

          /** Actual data is still in the process of building on the server; user needs to wait a bit longer. */
          PENDING: 'PENDING',

          /** Data could not be retrieved for this one particular source. */
          FAILED: 'FAILED',

          /** No new data to report - continue to display the existing data with no changes. */
          UP_TO_DATE: 'UP_TO_DATE'
        };
      }
    }]);

    return ItemCollection;
  }();
});
