function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/Item
 */
define(['nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/model/Severity', 'lex!nss'], function (Entity, Severity, lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      nssLex = _lexs[0];
  /**
   * Class representing an Item , e.g. "you have a log level set to FINE"
   *
   * @class
   * @alias module:nmodule/nss/rc/model/Item
   * @param {object} params
   * @param {module:nmodule/nss/rc/model/Entity} params.sourceEntity source entity of an item
   * @param {string} params.summary item summary
   * @param {string} params.description item description
   * @param {module:nmodule/nss/rc/model/Severity} params.severity item severity level
   * @throws {Error} if sourceEntity , summary or severity is missing
   */


  return /*#__PURE__*/function () {
    function Item() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          sourceEntity = _ref.sourceEntity,
          summary = _ref.summary,
          description = _ref.description,
          severity = _ref.severity;

      _classCallCheck(this, Item);

      if (!(sourceEntity instanceof Entity)) {
        throw new Error(nssLex.get('SecurityDashboardView.item.sourceEntity.error'));
      }

      if (typeof summary !== 'string') {
        throw new Error(nssLex.get('SecurityDashboardView.item.summary.error'));
      }

      if (!(severity instanceof Severity)) {
        throw new Error(nssLex.get('SecurityDashboardView.item.severity.error'));
      }

      this.$sourceEntity = sourceEntity;
      this.$summary = summary;
      this.$description = description || '';
      this.$severity = severity;
    }
    /**
     * @returns {module:nmodule/nss/rc/model/Entity} source Entity of the item
     */


    _createClass(Item, [{
      key: "getSourceEntity",
      value: function getSourceEntity() {
        return this.$sourceEntity;
      }
      /**
       * @returns {string} summary of the item
       */

    }, {
      key: "getSummary",
      value: function getSummary() {
        return this.$summary;
      }
      /**
       * @returns {string} description of the item
       */

    }, {
      key: "getDescription",
      value: function getDescription() {
        return this.$description;
      }
      /**
       * @returns {module:nmodule/nss/rc/model/Severity} severity of the item
       */

    }, {
      key: "getSeverity",
      value: function getSeverity() {
        return this.$severity;
      }
    }]);

    return Item;
  }();
});
