function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/model/Entity
 */
define(['lex!nss'], function (lexs) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      nssLex = _lexs[0];
  /**
   * Class representing an Entity, e.g. "User Service" or
   * "Fox Service".
   *
   * @class
   * @alias module:nmodule/nss/rc/model/Entity
   * @param {object} params
   * @param {string} params.displayName entity display name
   * @param {string} params.ord entity ord
   * @param {string[]} [params.icon=[]] array of strings that define an icon
   * for this entity
   * @throws {Error} if displayName or ord is missing
   */


  return /*#__PURE__*/function () {
    function Entity() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          name = _ref.name,
          _ref$displayName = _ref.displayName,
          displayName = _ref$displayName === void 0 ? name : _ref$displayName,
          ord = _ref.ord,
          icon = _ref.icon;

      _classCallCheck(this, Entity);

      if (typeof name !== 'string') {
        throw new Error(nssLex.get('SecurityDashboardView.entity.displayName.error'));
      }

      if (!(typeof ord === 'string' || ord)) {
        throw new Error(nssLex.get('SecurityDashboardView.entity.ord.error'));
      }

      this.$displayName = displayName;
      this.$name = name;
      this.$ord = String(ord);
      this.$icon = icon || [];
    }
    /**
     * @returns {string} entity display name
     */


    _createClass(Entity, [{
      key: "getDisplayName",
      value: function getDisplayName() {
        return this.$displayName;
      }
      /**
       * @returns {string} entity name
       */

    }, {
      key: "getName",
      value: function getName() {
        return this.$name;
      }
      /**
       * @returns {string} entity ord
       */

    }, {
      key: "getOrd",
      value: function getOrd() {
        return this.$ord;
      }
      /**
       * @returns {string[]} entity icon
       */

    }, {
      key: "getIcon",
      value: function getIcon() {
        return this.$icon;
      }
      /**
       * Checks for equality between this Entity and another.
       * 
       * @param {module:nmodule/nss/rc/model/Entity} srcEntity 
       * @returns {boolean} true if the other object is equal to this one.
       */

    }, {
      key: "equals",
      value: function equals(srcEntity) {
        return srcEntity.getName() === this.getName();
      }
    }]);

    return Entity;
  }();
});
