function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/SourceOverviewWidget
 * */
define(['baja!', 'jquery', 'Promise', 'bajaux/events', 'log!nmodule.nss.rc.fe.SourceOverviewWidget', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/nss/rc/fe/CountsBySeverityWidget', 'nmodule/webChart/rc/donut/DonutChartWidget', 'nmodule/nss/rc/model/SourceCollection', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/model/Entity', 'nmodule/nss/rc/util/securityDashboardUtil', 'lex!nss', 'css!nmodule/nss/rc/nss'], function (baja, $, Promise, events, log, Widget, BaseWidget, IconEditor, CountsBySeverityWidget, DonutChartWidget, SourceCollection, ItemCollection, Entity, securityDashboardUtil, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
      nssLex = _lexicon[0];

  var sourceOverviewWidgetHtml = function sourceOverviewWidgetHtml() {
    return "\n  <div class=\"sourceOverview-entity\">\n    <span class=\"icon\"></span>\n    <span class=\"displayName\"></span> \n  </div>\n  <div class=\"sourceOverview-bottom\">\n    <span class=\"donutChart\"></span>\n    <span class=\"CountsBySeverityWidget\"></span>\n  </div>\n ";
  };
  /**
   * Shows information about SourceCollection on a Donut Chart, CountsBySeverityWidget and Entity element.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/SourceOverviewWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(SourceOverviewWidget, _BaseWidget);

    var _super = _createSuper(SourceOverviewWidget);

    function SourceOverviewWidget() {
      _classCallCheck(this, SourceOverviewWidget);

      return _super.apply(this, arguments);
    }

    _createClass(SourceOverviewWidget, [{
      key: "doInitialize",

      /**
       * Adds `SourceOverviewWidget` class to the dom.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      value: function doInitialize(dom) {
        var _this = this;

        dom.html(sourceOverviewWidgetHtml()).addClass('SourceOverviewWidget');
        var countBySevWidget = new CountsBySeverityWidget({
          properties: {
            horizontal: true
          }
        });
        this.$getDashboardService().onItemCollectionUpdated(function (itemCollection) {
          _this.value().updateItemCollection(itemCollection);

          return _this.$refresh();
        });
        return Promise.all([securityDashboardUtil.getSeverityColors().then(function (color) {
          return new DonutChartWidget({
            properties: {
              label: nssLex.get('SecurityDashboardView.donutChartWidget.label.text'),
              color: color,
              countYOffset: 0
            }
          }).initialize(_this.$getDonutChartElement());
        }), countBySevWidget.initialize(this.$getCountsBySeverityElement()), new IconEditor().initialize(this.$getIconElement())]);
      }
      /**
       * Creates the SourceOverviewWidget for the input SourceCollection
       * @param {module:nmodule/nss/rc/model/SourceCollection} sourceCollection
       * @returns {Promise} Rendered SourceOverviewWidget wrapped as a Promise
       * @throws {Error} if the input is not a SourceCollection type.
       */

    }, {
      key: "doLoad",
      value: function doLoad(sourceCollection) {
        if (!(sourceCollection instanceof SourceCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.type.required.error'));
        }

        return this.$refresh();
      }
    }, {
      key: "$refresh",
      value: function $refresh() {
        var _this2 = this;

        var sourceCollection = this.value();
        return Promise.all([this.$getDonutChartWidget().load(securityDashboardUtil.getTypeAndCountForSeverity(sourceCollection.getCountsBySeverity())), this.$getCountsBySeverityWidget().load(sourceCollection.getCountsBySeverity()), this.$getIconWidget().load(sourceCollection.getSourceEntity().getIcon())]).then(function () {
          _this2.jq().find('.sourceOverview-entity .displayName').text(sourceCollection.getSourceEntity().getDisplayName());
        });
      }
      /**
       * Destroys all children of the editor.
       *
       * @returns {Promise}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SourceOverviewWidget');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "$getIconElement",

      /**
       * @private
       * @returns {JQuery}
       */
      value: function $getIconElement() {
        return this.jq().find('.sourceOverview-entity .icon');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getIconWidget",
      value: function $getIconWidget() {
        return Widget["in"](this.$getIconElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getCountsBySeverityElement",
      value: function $getCountsBySeverityElement() {
        return this.jq().find('.CountsBySeverityWidget');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getCountsBySeverityWidget",
      value: function $getCountsBySeverityWidget() {
        return Widget["in"](this.$getCountsBySeverityElement());
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getDonutChartElement",
      value: function $getDonutChartElement() {
        return this.jq().find('.sourceOverview-bottom .donutChart');
      }
      /**
       * @private
       * @returns {module:bajaux/Widget}
       */

    }, {
      key: "$getDonutChartWidget",
      value: function $getDonutChartWidget() {
        return Widget["in"](this.$getDonutChartElement());
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
       */

    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return this.properties().getValue('dashboardService');
      }
    }]);

    return SourceOverviewWidget;
  }(BaseWidget);
});
