function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Karthik Harpanhalli
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/SourceCollectionWidget
 **/
define(['jquery', 'Promise', 'underscore', 'baja!', 'bajaux/Widget', 'bajaux/mixin/responsiveMixIn', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/nss/rc/fe/SourceOverviewWidget', 'nmodule/nss/rc/fe/SourceCollectionCompositeEditor', 'nmodule/nss/rc/model/SourceCollection', 'log!nmodule.nss.rc.fe.SourceOverviewWidget', 'nmodule/nss/rc/fe/SourceCollectionCompositeEditor', 'lex!nss'], function ($, Promise, _, baja, Widget, responsiveMixIn, fe, BaseWidget, SourceOverviewWidget, SourceCollectionCompositeEditor, SourceCollection, log, CountsBySeverityWidget, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
      nssLex = _lexicon[0];

  var logSevere = log.severe.bind(log);

  var tpl = function tpl() {
    return "\n      <div class=\"DashboardTitle\">\n        <span><h2 class=\"title\"></h2></span>\n        <span class=\"Timestamp\"></span>\n      </div>\n      <div class=\"SourceCollItemCollectionContainer\">\n      </div>\n     ";
  };
  /**
   * Shows the complete dashboard that has ItemCollectionSummaryWidgets and
   * SourceOverviewWidget
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/SourceCollectionWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(SourceCollectionWidget, _BaseWidget);

    var _super = _createSuper(SourceCollectionWidget);

    function SourceCollectionWidget() {
      var _this;

      _classCallCheck(this, SourceCollectionWidget);

      _this = _super.apply(this, arguments);
      responsiveMixIn(_assertThisInitialized(_this), {
        'responsive-xxs': {
          maxWidth: 560
        },
        'responsive-xs': {
          maxWidth: 679
        },
        'responsive-sm': {
          minWidth: 680
        },
        'responsive-md': {
          minWidth: 1080
        },
        'responsive-lg': {
          minWidth: 1440
        },
        'responsive-xlg': {
          minWidth: 1890
        }
      });
      return _this;
    }
    /**
     * Adds `ItemCollectionSummaryWidget` and `SourceOverviewWidget` class.
     *
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(SourceCollectionWidget, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('SourceCollectionWidget');
        dom.on('severityFilterChanged', '.SourceOverviewWidget', function (e, ed, activeFilters) {
          _this2.$applyFilterOnItemCollectionSummaryWidget(activeFilters)["catch"](logSevere);
        });
        var itemSummariesWidget = new SourceCollectionCompositeEditor({
          properties: this.properties().subset('dashboardService', 'baseOrd').toValueMap()
        });
        return itemSummariesWidget.initialize(dom.find('.SourceCollItemCollectionContainer'));
      }
    }, {
      key: "doLoad",

      /**
       * Creates the SourceCollectionWidget for the input sourceCollection
       * @param {module:nmodule/nss/rc/model/SourceCollection} sourceCollection
       * @returns {Promise} Rendered SourceCollectionWidget wrapped as a
       * Promise (or) a error if the input is not an ItemCollection type.
       */
      value: function doLoad(sourceCollection) {
        var _this3 = this;

        if (!(sourceCollection instanceof SourceCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.sourceCollection.type.required.error'));
        }

        var cardsWidget = this.$getSourceCollectionArrayWidget();
        var baseOrd = sourceCollection.getSourceEntity().getOrd();
        cardsWidget.properties().add('baseOrd', baseOrd);
        return cardsWidget.load([sourceCollection].concat(sourceCollection.getItemCollections())).then(function () {
          var displayName = sourceCollection.getSourceEntity().getDisplayName();

          _this3.jq().find('.DashboardTitle .title').text(displayName);

          var timestamp = sourceCollection.getTimestamp();

          if (timestamp) {
            var relTime = baja.RelTime.make(timestamp - new Date());

            var timestampElement = _this3.jq().find('.DashboardTitle .Timestamp');

            return relTime.toFriendlyString().then(function (intervalString) {
              timestampElement.text(nssLex.get('SecurityDashboardView.sourceCollection.timestampLabel', intervalString));
            });
          }
        });
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/SourceOverviewWidget}
       */

    }, {
      key: "$getSourceOverviewWidget",
      value: function $getSourceOverviewWidget() {
        return Widget["in"](this.jq().find('.SourceOverviewWidget'));
      }
      /**
       * CountsBySevWidgetContainer will be emitted.
       * @private
       * @return {Widget}
       */

    }, {
      key: "$getSourceCollectionArrayWidget",
      value: function $getSourceCollectionArrayWidget() {
        return Widget["in"](this.jq().find('.SourceCollItemCollectionContainer'));
      }
      /**
       * loads the filtered itemList into the item collection summary widget.
       * @private
       * @param {module:nmodule/nss/rc/model/Severity[]} activeFilters - array of Severity Object
       * @returns {Promise} loads itemContainer with filtered itemList
       */

    }, {
      key: "$applyFilterOnItemCollectionSummaryWidget",
      value: function $applyFilterOnItemCollectionSummaryWidget(activeFilters) {
        this.jq().toggleClass('filter-show-none', activeFilters.length === 0);
        return Promise.all(_.map(this.jq().find('.ItemCollectionSummaryWidget'), function (itemCollectionSummaryDom) {
          var itemCollectionSummaryWidget = Widget["in"](itemCollectionSummaryDom);
          return itemCollectionSummaryWidget.applyFilter(activeFilters);
        }));
      }
      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('filter-show-none');
        this.jq().removeClass('SourceCollectionWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return SourceCollectionWidget;
  }(BaseWidget);
});
