function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/SecurityDashboard
 */
define(['baja!', 'baja!nss:SecurityDashboardViewMode', 'lex!nss', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/commands/ToggleCommandGroup', 'bajaux/util/CommandButtonGroup', 'dialogs', 'Promise', 'underscore', 'nmodule/nss/rc/fe/SourceCollectionWidget', 'nmodule/nss/rc/rpc/rpc', 'nmodule/nss/rc/rpc/StationDashboardService', 'nmodule/nss/rc/rpc/SystemDashboardService', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/util/htmlUtils'], function (baja, types, lexs, Widget, Command, ToggleCommandGroup, CommandButtonGroup, dialogs, Promise, _, SourceCollectionWidget, rpc, StationDashboardService, SystemDashboardService, BaseWidget, fe, htmlUtils) {
  'use strict';

  var DELAY = 200;

  var _lexs = _slicedToArray(lexs, 1),
      nssLex = _lexs[0];

  var escapeHtml = htmlUtils.escapeHtml;
  var UNSPECIFIED_VIEW = 'unspecifiedView';
  var STATION_VIEW = 'stationView';
  var SYSTEM_VIEW = 'systemView';

  var tpl = function tpl() {
    return "\n    <div class=\"CommandButtonGroup\"></div>\n    <div class=\"SourceCollectionWidget\"></div>\n  ";
  };
  /**
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/nss/rc/fe/SecurityDashboard
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(SecurityDashboard, _BaseWidget);

    var _super = _createSuper(SecurityDashboard);

    function SecurityDashboard(params) {
      var _this;

      _classCallCheck(this, SecurityDashboard);

      _this = _super.call(this, _.extend({
        moduleName: 'nss',
        keyName: 'SecurityDashboardView'
      }, params));

      _this.properties().addAll({
        name: 'mode',
        typeSpec: 'nss:SecurityDashboardViewMode',
        value: UNSPECIFIED_VIEW
      }, {
        name: 'selectedMode',
        typeSpec: 'nss:SecurityDashboardViewMode',
        value: UNSPECIFIED_VIEW,
        parameter: true,
        // makes configurable as part of a view query
        hidden: true,
        "transient": true
      });

      _this.$viewSelectorGroup = null;
      _this.$dashboardService = null;
      return _this;
    }
    /**
     * @param {JQuery} dom
     */


    _createClass(SecurityDashboard, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this2 = this;

        dom.html(tpl()).addClass('SecurityDashboard');
        this.getCommandGroup().add(new Command({
          module: 'nss',
          lex: 'SecurityDashboardView.refreshCommand',
          func: function func() {
            return _this2.load(_this2.value());
          }
        }));
        return new CommandButtonGroup({
          properties: {
            toolbar: true
          }
        }).initialize(dom.children('.CommandButtonGroup'));
      }
      /**
       * @param {baja.Component} component
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(component) {
        var _this3 = this;

        var ord = component.getNavOrd();
        return showLoadingWhile(rpc.getDashboardStatus(ord).then(function (dashboardStatus) {
          return _this3.$applyDashboardStatus(dashboardStatus);
        })["catch"](function (err) {
          _this3.jq().html("<h1>".concat(escapeHtml(err.message), "</h1>"));
        }).then(function (initialView) {
          return initialView && _this3.$initializeView(initialView);
        }));
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('SecurityDashboard');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }
      /**
       * @private
       * @param {object} params the result of a call to `getDashboardStatus`
       * @returns {Promise.<string>} the view type that should be initially shown
       */

    }, {
      key: "$applyDashboardStatus",
      value: function $applyDashboardStatus(_ref) {
        var _this4 = this;

        var stationDashboardStatus = _ref.stationDashboardStatus,
            systemDashboardStatus = _ref.systemDashboardStatus;
        var stationEnabled = stationDashboardStatus === 'enabled';
        var systemEnabled = systemDashboardStatus === 'enabled';

        if (!stationEnabled && !systemEnabled) {
          throw new Error(nssLex.get('SecurityDashboardView.noViewsAvailable'));
        }

        var configuredMode = this.$getConfiguredMode();
        var selectedMode = this.$getSelectedMode() || configuredMode || systemEnabled && SYSTEM_VIEW || stationEnabled && STATION_VIEW;

        if (selectedMode === SYSTEM_VIEW && !systemEnabled) {
          selectedMode = STATION_VIEW;
        }

        if (selectedMode === STATION_VIEW && !stationEnabled) {
          selectedMode = SYSTEM_VIEW;
        }

        var isStationView = selectedMode === STATION_VIEW;
        var commands;

        if (stationEnabled && systemEnabled && !configuredMode) {
          commands = [{
            module: 'nss',
            lex: "SecurityDashboardView.commands.systemView",
            value: SYSTEM_VIEW,
            selected: !isStationView
          }, {
            module: 'nss',
            lex: "SecurityDashboardView.commands.stationView",
            value: STATION_VIEW,
            selected: isStationView
          }];
        } else {
          commands = [];
        }

        var viewSelectorGroup = this.$viewSelectorGroup = new ToggleCommandGroup({
          onChange: function onChange(mode) {
            if (mode !== _this4.$getSelectedMode()) {
              return _this4.$switchView(mode);
            }
          },
          commands: commands
        });
        return this.$getViewSelectorButtonGroup().load(viewSelectorGroup).then(function () {
          return selectedMode;
        });
      }
      /**
       * Set up the dashboard service and load the appropriate data for system or
       * station view.
       * @param {string} mode
       * @returns {Promise}
       */

    }, {
      key: "$initializeView",
      value: function $initializeView(mode) {
        var ord = this.value().getNavOrd().relativizeToSession();
        var dashboardService = this.$dashboardService = makeDashboardService(mode);
        var existing = this.$getSourceCollectionWidget();
        var sourceCollectionElement = this.$getSourceCollectionElement();
        this.jq().toggleClass('system-view', mode === SYSTEM_VIEW);
        this.$setSelectedMode(mode);
        return Promise.resolve(existing && existing.destroy()).then(function () {
          return dashboardService.getSourceCollection(ord);
        }).then(function (sourceCollection) {
          return fe.buildFor({
            type: SourceCollectionWidget,
            dom: sourceCollectionElement,
            value: sourceCollection,
            properties: {
              dashboardService: dashboardService
            }
          });
        });
      }
      /**
       * Switch to Station or System view. Should only be called if already
       * initialized with a particular view type.
       * @param {string} mode
       * @returns {Promise}
       */

    }, {
      key: "$switchView",
      value: function $switchView(mode) {
        return showLoadingWhile(this.$initializeView(mode));
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
       */

    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return this.$dashboardService;
      }
      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */

    }, {
      key: "$getRefreshCommand",
      value: function $getRefreshCommand() {
        return this.getCommandGroup().get(0);
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getSourceCollectionElement",
      value: function $getSourceCollectionElement() {
        return this.jq().children('.SourceCollectionWidget');
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/SourceCollectionWidget}
       */

    }, {
      key: "$getSourceCollectionWidget",
      value: function $getSourceCollectionWidget() {
        return Widget["in"](this.$getSourceCollectionElement());
      }
      /**
       * @private
       * @returns {module:bajaux/commands/Command|null} command to switch to
       * Station View, or null if Station View is disabled
       */

    }, {
      key: "$getStationViewCommand",
      value: function $getStationViewCommand() {
        return this.$viewSelectorGroup.get(1);
      }
      /**
       * @private
       * @returns {module:bajaux/commands/Command|null} command to switch to
       * System View, or null if System View is disabled
       */

    }, {
      key: "$getSystemViewCommand",
      value: function $getSystemViewCommand() {
        return this.$viewSelectorGroup.get(0);
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButtonGroup}
       */

    }, {
      key: "$getViewSelectorButtonGroup",
      value: function $getViewSelectorButtonGroup() {
        return Widget["in"](this.jq().children('.CommandButtonGroup'));
      }
      /**
       * @private
       * @returns {string|null} a `nss:SecurityDashboardViewMode` tag indicating
       * the currently selected mode (selectable by the user)
       */

    }, {
      key: "$getSelectedMode",
      value: function $getSelectedMode() {
        var mode = this.properties().getValue('selectedMode');
        return mode !== UNSPECIFIED_VIEW && mode;
      }
      /**
       * @private
       * @param {string} mode
       */

    }, {
      key: "$setSelectedMode",
      value: function $setSelectedMode(mode) {
        this.properties().setValue('selectedMode', mode);
      }
      /**
       * @private
       * @returns {string|null} a `nss:SecurityDashboardViewMode` tag indicating
       * the configured mode (not selectable by the user; if present will force
       * the dashboard into that mode)
       */

    }, {
      key: "$getConfiguredMode",
      value: function $getConfiguredMode() {
        var mode = this.properties().getValue('mode');
        return mode !== UNSPECIFIED_VIEW && mode;
      }
      /**
       * @private
       * @param {string} mode
       */

    }, {
      key: "$setConfiguredMode",
      value: function $setConfiguredMode(mode) {
        this.properties().setValue('mode', mode);
      }
    }]);

    return SecurityDashboard;
  }(BaseWidget);

  function showLoadingWhile(prom) {
    dialogs.showLoading(DELAY, prom);
    return prom;
  }
  /**
   * @param {string} viewType
   * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
   */


  function makeDashboardService(viewType) {
    switch (viewType) {
      case STATION_VIEW:
        return new StationDashboardService();

      case SYSTEM_VIEW:
        return new SystemDashboardService();

      default:
        throw new Error('unknown view type ' + viewType);
    }
  }
});
