function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/ItemWidget
 */
define(['jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/nss/rc/fe/SeverityWidget', 'nmodule/nss/rc/model/Item', 'lex!nss', 'css!nmodule/nss/rc/nss'], function ($, Promise, Widget, BaseWidget, fe, SeverityWidget, Item, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
      nssLex = _lexicon[0];
  /**
   * Returns an ItemWidget for an independent item & displays { SeverityIcon -> Item } on the UI.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/ItemWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(ItemWidget, _BaseWidget);

    var _super = _createSuper(ItemWidget);

    function ItemWidget() {
      _classCallCheck(this, ItemWidget);

      return _super.apply(this, arguments);
    }

    _createClass(ItemWidget, [{
      key: "doInitialize",

      /**
       * Adds the 'ItemWidget' class to the dom.
       * @param {JQuery} dom - Html to fill.
       * @returns {Promise} Initialization promise of the SeverityWidget.
       */
      value: function doInitialize(dom) {
        dom.addClass('ItemWidget');
        var severityElement = $('<div/>').addClass('SeverityWidget'),
            itemElement = $('<div/>').addClass('ItemContainer'),
            summarySpan = $('<span/>').addClass('summary'),
            descriptionSpan = $('<span/>').addClass('description');
        itemElement.append(summarySpan);
        itemElement.append(descriptionSpan);
        dom.append(severityElement);
        dom.append(itemElement);
        return new SeverityWidget().initialize(dom.find('.SeverityWidget'));
      }
    }, {
      key: "doLoad",

      /**
       * Creates the ItemWidget for the input Item
       * @param {module:nmodule/nss/rc/model/Item} item - Display line item with a summary, description and severity.
       * @returns {Promise} Rendered ItemWidget wrapped as a Promise (or) a error if the input is not an Item type.
       */
      value: function doLoad(item) {
        var _this = this;

        if (!(item instanceof Item)) {
          throw new Error(nssLex.get('SecurityDashboardView.itemWidget.item.required.error'));
        }

        return this.$getSeverityWidget().load(item.getSeverity()).then(function () {
          _this.jq().find('.ItemContainer .summary').text(item.getSummary());

          _this.jq().find('.ItemContainer .description').text(item.getDescription());
        });
      }
    }, {
      key: "doDestroy",

      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */
      value: function doDestroy() {
        this.jq().removeClass('ItemWidget');
        return this.$getSeverityWidget().destroy();
      }
    }, {
      key: "$getSeverityWidget",

      /**
       * Returns a severity widget.
       * @private
       * @return {module:nmodule/nss/rc/fe/SeverityWidget} SeverityWidget that was instantiated.
       */
      value: function $getSeverityWidget() {
        return Widget["in"](this.jq().find('.SeverityWidget'));
      }
    }]);

    return ItemWidget;
  }(BaseWidget);
});
