function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/ItemCollectionSummaryWidget
 */
define(['baja!', 'lex!nss', 'log!nmodule.nss.rc.fe.ItemCollectionSummaryWidget', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/util/CommandButton', 'jquery', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/nss/rc/fe/SeverityWidget', 'nmodule/nss/rc/fe/ItemsArrayCompositeEditor', 'nmodule/nss/rc/fe/ItemCollectionDetailsWidget', 'nmodule/nss/rc/fe/CountsBySeverityWidget', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/util/securityDashboardUtil', 'nmodule/webChart/rc/donut/DonutChartWidget', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/webEditors/rc/fe/BaseWidget', 'css!nmodule/nss/rc/nss'], function (baja, lexicon, log, Widget, Command, CommandButton, $, Promise, asyncUtils, SeverityWidget, ItemsArrayCompositeEditor, ItemCollectionDetailsWidget, CountsBySeverityWidget, ItemCollection, securityDashboardUtil, DonutChartWidget, feDialogs, BaseWidget) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
      nssLex = _lexicon[0];

  var REFRESHING = nssLex.get('SecurityDashboardView.itemCollectionSummary.refreshing');
  var waitInterval = asyncUtils.waitInterval;
  var getSeverityColors = securityDashboardUtil.getSeverityColors,
      getTypeAndCountForSeverity = securityDashboardUtil.getTypeAndCountForSeverity,
      isLinkable = securityDashboardUtil.isLinkable;
  var logSevere = log.severe.bind(log);
  var REFRESH_TIMEOUT = 5000;
  var TIMESTAMP_UPDATE_INTERVAL = 60000;

  var getTemplate = function getTemplate() {
    return "\n      <div class=\"LeftContainer\">\n        <div class = \"EntityContainer\">\n          <span class=\"SeverityWidget\" />\n          <span class=\"EntityHeader entityName\"><a class=\"entityNameLink\" /></span>\n        </div>\n        <div class=\"TsRefreshContainer\">\n          <span class=\"Refresh\" />\n          <span class=\"Timestamp\" />\n        </div>\n        <div class=\"DonutChartContainer\" />\n        <div class=\"CountsBySeverityWidget\" />\n      </div>\n      <div class=\"RightWrapper\">\n        <div class=\"RightContainer\">\n          <div class=\"ItemsContainer\" />\n        </div>\n        <div class=\"MoreContainer\">\n          <a href=\"#\">".concat(nssLex.getSafe('SecurityDashboardView.itemCollectionSummary.more.text'), "</a>\n        </div>\n      </div>");
  };
  /**
   * Displays the ItemCollectionSummary as a card in the Security Dashboard.
   *
   * It supports the following bajaux Properties:
   *
   * - `dashboardService`: IDashboardService used to retrieve new
   *   ItemCollection data from the server.
   * - `baseOrd`: a base ORD used when requesting a new ItemCollection.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/ItemCollectionSummaryWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @see module:nmodule/nss/rc/rpc/rpc.IDashboardService
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(ItemCollectionSummaryWidget, _BaseWidget);

    var _super = _createSuper(ItemCollectionSummaryWidget);

    function ItemCollectionSummaryWidget() {
      _classCallCheck(this, ItemCollectionSummaryWidget);

      return _super.apply(this, arguments);
    }

    _createClass(ItemCollectionSummaryWidget, [{
      key: "$showItemCollectionDetailsDialog",

      /**
       * Show details about the ItemCollection in a popup.
       *
       * @private
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection - Collection of the items to display.
       * @return {Promise}
       */
      value: function $showItemCollectionDetailsDialog(itemCollection) {
        return feDialogs.showFor({
          type: ItemCollectionDetailsWidget,
          value: itemCollection,
          formFactor: 'compact',
          properties: this.properties().toValueMap()
        });
      }
    }, {
      key: "$getBaseOrd",

      /**
       * The base ORD against to resolve the servlet query to refresh this
       * ItemCollection.
       * @private
       * @returns {string|baja.Ord}
       */
      value: function $getBaseOrd() {
        return this.properties().getValue('baseOrd');
      }
      /**
       * DonutCharContainer will be emitted.
       * @private
       * @return {module:bajaux/Widget}
       */

    }, {
      key: "$getDonutChartWidget",
      value: function $getDonutChartWidget() {
        return Widget["in"](this.jq().find('.DonutChartContainer'));
      }
      /**
       * CountsBySevWidgetContainer will be emitted.
       * @private
       * @return {module:nmodule/nss/rc/fe/CountsBySeverityWidget}
       */

    }, {
      key: "$getCountsBySeverityWidget",
      value: function $getCountsBySeverityWidget() {
        return Widget["in"](this.jq().find('.CountsBySeverityWidget'));
      }
      /**
       * ItemsContainer will be emitted.
       * @private
       * @return {module:bajaux/Widget}
       */

    }, {
      key: "$getItemsArrayWidget",
      value: function $getItemsArrayWidget() {
        return Widget["in"](this.jq().find('.ItemsContainer'));
      }
      /**
       * @private
       * @returns {number} how long to wait after a refresh request before
       * polling for data again
       */

    }, {
      key: "$getRefreshTimeout",
      value: function $getRefreshTimeout() {
        return REFRESH_TIMEOUT;
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/rpc/rpc.IDashboardService}
       */

    }, {
      key: "$getDashboardService",
      value: function $getDashboardService() {
        return this.properties().getValue('dashboardService');
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getSeverityWidgetElement",
      value: function $getSeverityWidgetElement() {
        return this.jq().find('.EntityContainer .SeverityWidget');
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/SeverityWidget} widget showing the max severity for the ItemCollection
       */

    }, {
      key: "$getSeverityWidget",
      value: function $getSeverityWidget() {
        return Widget["in"](this.$getSeverityWidgetElement());
      }
      /**
       * @private
       * @returns {module:bajaux/commands/Command}
       */

    }, {
      key: "$getRefreshCommand",
      value: function $getRefreshCommand() {
        return this.getCommandGroup().get(0);
      }
      /**
       * @private
       * @returns {module:bajaux/util/CommandButton}
       */

    }, {
      key: "$getRefreshButton",
      value: function $getRefreshButton() {
        return Widget["in"](this.jq().find('.Refresh'));
      }
      /**
       * @private
       * @returns {JQuery}
       */

    }, {
      key: "$getTimestampElement",
      value: function $getTimestampElement() {
        return this.jq().find('.Timestamp');
      }
      /**
       * Hyperlink to the ORD of this item collection's source.
       * @private
       */

    }, {
      key: "$doHyperlink",
      value: function $doHyperlink() {
        securityDashboardUtil.hyperlink(this.value().getSourceEntity().getOrd(), this.$getBaseOrd());
      }
      /**
       * Wait a bit for the server to finish refreshing its data, request it,
       * and display it.
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$refreshLater",
      value: function $refreshLater() {
        var _this = this;

        this.$getTimestampElement().text(REFRESHING);
        return waitInterval(this.$getRefreshTimeout()).then(function () {
          return _this.$refresh();
        });
      }
      /**
       * Requests a refresh of data from the server.
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$requestRefresh",
      value: function $requestRefresh() {
        var entity = this.value().getSourceEntity();
        return this.$getDashboardService().requestRefresh(this.$getBaseOrd(), entity.getName());
      }
      /**
       * Fetch fresh data from the server and update this widget with a new
       * ItemCollection.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$refresh",
      value: function $refresh() {
        var _this2 = this;

        if (this.isDestroyed()) {
          return Promise.resolve();
        }

        var itemCollection = this.value();
        var entity = itemCollection.getSourceEntity();
        return this.$getDashboardService().getItemCollection(this.$getBaseOrd(), entity.getName(), itemCollection.getTimestamp()).then(function (itemCollection) {
          return _this2.load(itemCollection);
        });
      }
      /**
       * Adds the 'ItemCollectionSummaryWidget' class to the dom.
       * @param {JQuery} dom - Html to fill.
       * @return {Promise} Initialized field editors wrapped as a promise.
       */

    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        var _this3 = this;

        dom.addClass('ItemCollectionSummaryWidget');
        dom.append(getTemplate());
        dom.on('click', '.entityNameLink', function () {
          _this3.$doHyperlink();

          return false;
        });
        dom.on('click', '.MoreContainer a', function () {
          _this3.$showItemCollectionDetailsDialog(_this3.value())["catch"](logSevere);

          return false;
        });
        this.getCommandGroup().add(new Command({
          module: 'nss',
          lex: 'SecurityDashboardView.refreshCommand',
          func: function func() {
            _this3.$getRefreshCommand().setEnabled(false);

            return _this3.$requestRefresh().then(function () {
              return _this3.$refreshLater();
            });
          }
        }));
        this.$timestampTicket = setInterval(function () {
          _this3.$updateTimestamp()["catch"](logSevere);
        }, TIMESTAMP_UPDATE_INTERVAL);
        return Promise.all([getSeverityColors().then(function (color) {
          return new DonutChartWidget({
            properties: {
              label: '',
              color: color,
              width: 120,
              height: 120,
              radius: 45,
              countYOffset: 16
            }
          }).initialize(dom.find('.DonutChartContainer'));
        }), new CountsBySeverityWidget({
          properties: {
            horizontal: false
          }
        }).initialize(dom.find('.CountsBySeverityWidget')), new ItemsArrayCompositeEditor().initialize(dom.find('.ItemsContainer')), new SeverityWidget().initialize(this.$getSeverityWidgetElement()), new CommandButton().initialize(dom.find('.Refresh'))]);
      }
    }, {
      key: "doLoad",

      /**
       * Loads the CountsBySeverityWidget, DonutChartWidget, ItemCollectionContainer to the dom.
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection - Collection of the items to display.
       * @return {Promise|*}
       */
      value: function doLoad(itemCollection) {
        if (!(itemCollection instanceof ItemCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.itemCollection.type.required.error'));
        }

        var refreshCmd = this.$getRefreshCommand();
        var status = itemCollection.data('status');

        if (status === ItemCollection.status.UP_TO_DATE) {
          refreshCmd.setEnabled(true);
          return;
        }

        var dom = this.jq();
        var countsBySeverity = itemCollection.getCountsBySeverity();
        var items = itemCollection.getItems();
        var maxSeverity = itemCollection.getMaxSeverity();
        var sourceEntity = itemCollection.getSourceEntity(); // if we're still waiting for results, prevent the user from
        // re-refreshing and poll for the updated results later.

        if (status === ItemCollection.status.PENDING) {
          refreshCmd.setEnabled(false);
          this.$refreshLater()["catch"](logSevere);
        } else {
          refreshCmd.setEnabled(true);
        }

        var ord = baja.Ord.make(sourceEntity.getOrd());
        var entityName = dom.find('.entityName');

        if (isLinkable(ord)) {
          entityName.html($('<a class="entityNameLink">').text(sourceEntity.getDisplayName()).attr('href', ord.toUri()).attr('data-ord', ord));
        } else {
          entityName.text(sourceEntity.getDisplayName());
        }

        return Promise.all([this.$getDonutChartWidget().load(getTypeAndCountForSeverity(countsBySeverity)), this.$getCountsBySeverityWidget().load(countsBySeverity), this.$getItemsArrayWidget().load(items), this.$getRefreshButton().load(refreshCmd), maxSeverity && this.$getSeverityWidget().load(maxSeverity), this.$updateTimestamp()]);
      }
      /**
       * Update the contents of the timestamp display.
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$updateTimestamp",
      value: function $updateTimestamp() {
        var itemCollection = this.value();

        if (!itemCollection) {
          return Promise.resolve();
        }

        var timestamp = itemCollection.getTimestamp();
        var pending = itemCollection.data('status') === ItemCollection.status.PENDING;
        var timestampElement = this.$getTimestampElement();

        if (pending) {
          return Promise.resolve(timestampElement.text(REFRESHING));
        }

        if (!timestamp) {
          return Promise.resolve();
        }

        var relTime = baja.RelTime.make(timestamp - new Date());
        return relTime.toFriendlyString().then(function (intervalString) {
          timestampElement.text(nssLex.get('SecurityDashboardView.itemCollectionSummary.timestampLabel', intervalString));
        });
      }
      /**
       * loads the ItemsContainer with filtered item list.
       * @param  {module:nmodule/nss/rc/model/Severity[]} filter - array of Severity Object
       * @returns {Promise} loads itemContainer with filtered itemList
       */

    }, {
      key: "applyFilter",
      value: function applyFilter(filter) {
        var itemCollection = this.value();
        var emptyFilter = filter.length === 0;
        var more = this.jq().find(".MoreContainer").detach();

        if (emptyFilter) {
          more.appendTo(this.jq().find(".LeftContainer"));
        } else {
          more.appendTo(this.jq().find(".RightWrapper"));
        }

        return this.$getItemsArrayWidget().load(itemCollection.getItems(filter));
      }
      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ItemCollectionSummaryWidget');
        clearInterval(this.$timestampTicket);
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return ItemCollectionSummaryWidget;
  }(BaseWidget);
});
