function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Karthik Harpanhalli
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/ItemCollectionDetailsWidget
 */
define(['jquery', 'Promise', 'baja!', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/nss/rc/fe/ItemsArrayCompositeEditor', 'nmodule/nss/rc/fe/CountsBySeverityWidget', 'nmodule/nss/rc/model/ItemCollection', 'nmodule/nss/rc/fe/SeverityWidget', 'nmodule/nss/rc/util/securityDashboardUtil', 'log!nmodule.nss.rc.fe.ItemCollectionDetailsWidget', 'lex!nss'], function ($, Promise, baja, Widget, fe, BaseWidget, ItemsArrayCompositeEditor, CountsBySeverityWidget, ItemCollection, SeverityWidget, securityDashboardUtil, log, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
      nssLex = _lexicon[0];

  var isLinkable = securityDashboardUtil.isLinkable;
  var logSevere = log.severe.bind(log);

  var tpl = function tpl() {
    return "\n      <div class=\"EntityContainer\" >\n        <span class=\"entityIcon\"></span>\n        <span class=\"entityName\"></span> \n      </div>\n      <div>\n        <div class=\"CountsBySeverityWidget\"></div>\n      </div>\n      <div class=\"ItemsContainer\"></div>\n     ";
  };
  /**
   * Shows information about ItemCollection, Severity and Entity.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/ItemCollectionDetailsWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */


  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(ItemCollectionDetailsWidget, _BaseWidget);

    var _super = _createSuper(ItemCollectionDetailsWidget);

    function ItemCollectionDetailsWidget() {
      _classCallCheck(this, ItemCollectionDetailsWidget);

      return _super.apply(this, arguments);
    }

    _createClass(ItemCollectionDetailsWidget, [{
      key: "doInitialize",

      /**
       * Adds `ItemCollectionDetailsWidget` class.
       *
       * @param {JQuery} dom
       * @returns {Promise}
       */
      value: function doInitialize(dom) {
        var _this = this;

        dom.html(tpl()).addClass('ItemsCollectionDetailsWidget');
        dom.on('click', '.entityNameLink', function () {
          dom.trigger(BaseWidget.VALUE_READY_EVENT);

          _this.$doHyperlink();

          return false;
        });
        dom.on('severityFilterChanged', '.CountsBySeverityWidget', function (e, ed, activeFilters) {
          _this.$applyFilterOnItemCollectionDetailsWidget(activeFilters)["catch"](logSevere);
        });
        return Promise.all([new CountsBySeverityWidget({
          properties: {
            horizontal: true
          }
        }).initialize(dom.find('.CountsBySeverityWidget')), new ItemsArrayCompositeEditor().initialize(dom.find('.ItemsContainer')), new SeverityWidget().initialize(dom.find('.entityIcon'))]);
      }
    }, {
      key: "$doHyperlink",

      /**
       * Hyperlink to the ORD of this item collection's source.
       * @private
       */
      value: function $doHyperlink() {
        securityDashboardUtil.hyperlink(this.value().getSourceEntity().getOrd(), this.$getBaseOrd());
      }
      /**
       * Creates the ItemCollectionDetailWidget for the input ItemCollection
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection
       * @returns {Promise} Rendered ItemCollectionDetailWidget wrapped as a
       * Promise (or) a error if the input is not an ItemCollection type.
       */

    }, {
      key: "doLoad",
      value: function doLoad(itemCollection) {
        if (!(itemCollection instanceof ItemCollection)) {
          throw new Error(nssLex.get('SecurityDashboardView.itemCollection.type.required.error'));
        }

        return this.$resolveWidgets(itemCollection);
      }
    }, {
      key: "$resolveWidgets",

      /**
       * Creates the ItemCollectionDetailWidget for the input ItemCollection
       * @param {module:nmodule/nss/rc/model/ItemCollection} itemCollection
       * @returns {Promise} Rendered ItemCollectionDetailWidget wrapped as a
       * Promise
       */
      value: function $resolveWidgets(itemCollection) {
        var maxSeverity = itemCollection.getMaxSeverity();
        var sourceEntity = itemCollection.getSourceEntity();
        var ord = baja.Ord.make(sourceEntity.getOrd());
        var entityName = this.jq().find('.entityName');

        if (isLinkable(ord)) {
          entityName.html($('<a class="entityNameLink"/>').text(sourceEntity.getDisplayName()).attr('href', ord.toUri()).attr('data-ord', ord));
        } else {
          entityName.text(sourceEntity.getDisplayName());
        }

        return Promise.all([this.$getCountsBySeverityWidget().load(itemCollection.getCountsBySeverity()), this.$getItemsContainerWidget().load(itemCollection.getItems()), maxSeverity && this.$getSeverityWidget().load(maxSeverity)]);
      }
      /**
       * @private
       * @returns {string|baja.Ord}
       */

    }, {
      key: "$getBaseOrd",
      value: function $getBaseOrd() {
        return this.properties().getValue('baseOrd');
      }
      /**
       * @private
       * @returns {module:nmodule/nss/rc/fe/CountBySeverityWidget}
       */

    }, {
      key: "$getCountsBySeverityWidget",
      value: function $getCountsBySeverityWidget() {
        return Widget["in"](this.jq().find('.CountsBySeverityWidget'));
      }
      /**
       * @private
       * @return {module:nmodule/nss/rc/fe/ItemsArrayCompositeEditor}
       */

    }, {
      key: "$getItemsContainerWidget",
      value: function $getItemsContainerWidget() {
        return Widget["in"](this.jq().find('.ItemsContainer'));
      }
      /**
       * @private
       * @return {module:nmodule/nss/rc/fe/SeverityWidget}
       */

    }, {
      key: "$getSeverityWidget",
      value: function $getSeverityWidget() {
        return Widget["in"](this.jq().find('.entityIcon'));
      }
      /**
       * loads the filtered itemList into the item collection details widget.
       * @private
       * @param {module:nmodule/nss/rc/model/Severity[]} activeFilters - array of Severity Object
       * @return {Promise} re-rendering ItemCollectionDetailWidget wrapped as a
       * Promise
       */

    }, {
      key: "$applyFilterOnItemCollectionDetailsWidget",
      value: function $applyFilterOnItemCollectionDetailsWidget(activeFilters) {
        var itemCollection = this.value();
        return this.$getItemsContainerWidget().load(itemCollection.getItems(activeFilters));
      }
      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('ItemsCollectionDetailsWidget');
        return this.getChildWidgets().destroyAll();
      }
    }]);

    return ItemCollectionDetailsWidget;
  }(BaseWidget);
});
