function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Sai Komaravolu
 */

/**
 * API Status: **Private**
 * @module nmodule/nss/rc/fe/CountBySeverityWidget
 */
define(['jquery', 'Promise', 'underscore', 'bajaux/commands/ToggleCommand', 'bajaux/events', 'bajaux/util/CommandButton', 'nmodule/webEditors/rc/util/htmlUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/fe', 'nmodule/nss/rc/fe/SeverityWidget', 'lex!nss', 'css!nmodule/nss/rc/nss'], function ($, Promise, _, ToggleCommand, events, CommandButton, htmlUtils, BaseWidget, fe, SeverityWidget, lexicon) {
  'use strict';

  var _lexicon = _slicedToArray(lexicon, 1),
      nssLex = _lexicon[0];

  var showText = nssLex.get('CountsBySeverityWidget.filter.show');
  var hideText = nssLex.get('CountsBySeverityWidget.filter.displayName');
  var className = 'CountsBySeverityWidget';
  /**
   * Displays {Severity -> Severity-Count}, ordered by Severity types; Healthy, Warning and Critical.
   *
   * emits a `severityFilterChanged` tinyevent with an array of
   * {module:nmodule/nss/rc/model/Severity} severity items which
   * are currently selected to `show`.
   *
   * @class
   * @alias module:nmodule/nss/rc/fe/CountsBySeverityWidget
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   */

  return /*#__PURE__*/function (_BaseWidget) {
    _inherits(CountsBySeverityWidget, _BaseWidget);

    var _super = _createSuper(CountsBySeverityWidget);

    function CountsBySeverityWidget() {
      _classCallCheck(this, CountsBySeverityWidget);

      return _super.apply(this, arguments);
    }

    _createClass(CountsBySeverityWidget, [{
      key: "doInitialize",

      /**
       * Initializes the CountBySeverityWidget with html.
       *
       * @param {JQuery} dom - Html to fill.
       */
      value: function doInitialize(dom) {
        this.$severities = {};
        this.$noShowSeverities = {};
        dom.addClass(className);
        this.jq().toggleClass('horizontal', this.properties().getValue('horizontal', false));
      }
      /**
       * Loads the content for the widget.
       *
       * @param {Object[]} severityArr - Array of severity & count objects .
       * @param {module:nmodule/nss/rc/model/Severity} severityArr[].severity - Severity Object.
       * @param {Number} severityArr[].count - Count of the severities.
       * @returns {Promise} Rendered SecurityWidgets wrapped as a Promise.
       */

    }, {
      key: "doLoad",
      value: function doLoad(severityArr) {
        var _this = this;

        severityArr = severityArr || []; // Map of severities that we do not want to show.

        this.$noShowSeverities = _.extend({}, this.$severities, true);
        severityArr.map(function (value) {
          return delete _this.$noShowSeverities[value.severity.getName()];
        }); // Update severity widgets.

        return this.updateSeverityWidgets(severityArr);
      }
      /**
       * Removes the class from the jq() at the end of widget life cycle.
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('horizontal');
        return this.getChildWidgets().destroyAll();
      }
    }, {
      key: "doChanged",
      value: function doChanged(prop) {
        if (prop === 'horizontal') {
          this.jq().toggleClass('horizontal', this.properties().getValue('horizontal'));
        }
      }
      /**
       * Update the severity widgets along with the count and filter for
       * each item in the given array.
       *
       * severityArr[].severity is used as a key for each widget
       *
       * @param {Object[]} severityArr - Array of severity & count objects .
       * @param {module:nmodule/nss/rc/model/Severity} severityArr[].severity - Severity Object.
       * @param {Number} severityArr[].count - Count of the severities.
       * @returns {Promise} Resolves when the severity widgets have been updated
       */

    }, {
      key: "updateSeverityWidgets",
      value: function updateSeverityWidgets(severityArr) {
        var _this2 = this;

        this.jq().empty();
        return Promise.all(severityArr.map(function (value) {
          var severityCount = htmlUtils.escapeHtml(value.count);
          var severityName = htmlUtils.escapeHtml(value.severity.getName());
          var severityElement = $("<span class=\"".concat(severityName, " summary\">"));
          var countElement = $("<span class=\"count\">".concat(severityCount, "<span>"));
          var container = $("<div class=\"".concat(severityName, "Widget\"></div>"));
          var toggleFilter = $("<div class=\"filterCommand\"></div>");
          var toggleCommand = new ToggleCommand({
            module: 'nss',
            lex: 'CountsBySeverityWidget.filter',
            selected: true
          });
          toggleCommand.on(events.command.SELECTION_EVENT, function () {
            var selected = toggleCommand.isSelected();
            toggleCommand.setDisplayNameFormat(selected ? hideText : showText);

            _this2.$emitFilterEvent();
          });

          _this2.jq().append(container.append(severityElement).append(countElement).append(toggleFilter));

          _this2.$severities[severityName] = {
            countElement: countElement,
            toggleCommand: toggleCommand,
            severity: value.severity
          };
          return Promise.all([fe.buildFor({
            dom: severityElement,
            type: SeverityWidget,
            value: value.severity
          }), fe.buildFor({
            formFactor: 'mini',
            dom: toggleFilter,
            type: CommandButton,
            value: toggleCommand
          })]);
        }));
      }
      /**
       * Emit the `severityFilterChanged` tinyevent.
       *
       * @private
       */

    }, {
      key: "$emitFilterEvent",
      value: function $emitFilterEvent() {
        var activeFilters = [];

        for (var severityName in this.$severities) {
          if (this.$severities[severityName].toggleCommand.isSelected()) {
            activeFilters.push(this.$severities[severityName].severity);
          }
        }

        this.trigger('severityFilterChanged', activeFilters);
      }
    }]);

    return CountsBySeverityWidget;
  }(BaseWidget);
});
