/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/httpClient/rc/AddMorePointsCommand
 */
define([
  'baja!',
  'Promise',
  'bajaux/commands/Command'
], function (
  baja,
  Promise,
  Command
) {

  'use strict';

  /**
   * Command for calling poll on selected items.
   *
   * @class
   * @extends module:bajaux/commands/Command
   * @alias module:nmodule/httpClient/rc/AddMorePointsCommand
   * @param {module:nmodule/webEditors/rc/wb/mgr/Manager} manager
   */
  var AddMorePointsCommand = function AddMorePointsCommand(manager) {
    var that = this;

    Command.call(that, {
      module: 'httpClient',
      lex: 'cmd.http.addMore',
      enabled: false,
      func: function () {
        var promises = [],
          selectedRows = manager.getMainTable().getSelectedRows();

        if (!that.$shouldBeEnabled(manager)) {
          return;
        }

        selectedRows.forEach(function (row) {
          promises.push(row.getSubject().getProxyExt().send());
        });

        return new baja.comm.Batch().commit(
          Promise.all(promises)
        );
      }
    });

  };

  AddMorePointsCommand.prototype = Object.create(Command.prototype);
  AddMorePointsCommand.prototype.constructor = AddMorePointsCommand;

  /**
   * @private
   * @param manager manager with which to check whether this should be enabled
   * @returns {boolean} true if the command should be enabled
   */
  AddMorePointsCommand.prototype.$shouldBeEnabled = function (manager) {
    return manager.getMainTable().getSelectedRows().length === 1;
  };

  return AddMorePointsCommand;
});
