/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['nmodule/schedule/rc/model/TimeOfDay'], function (TimeOfDay) {
  'use strict';

  var MILLIS_IN_HALF_HOUR = 1800000,
      MILLIS_IN_DAY = 86400000;

  function isTime(time) {
    return time instanceof TimeOfDay;
  }

  var exports = {
    MILLIS_IN_DAY: MILLIS_IN_DAY,
    MILLIS_IN_HALF_HOUR: MILLIS_IN_HALF_HOUR
  };

  exports.makeTime = function (millis) {
    if (isTime(millis)) {
      return millis;
    }

    if (typeof millis !== 'number') {
      throw new Error('number required');
    }

    millis = (millis + MILLIS_IN_DAY) % MILLIS_IN_DAY;
    return new TimeOfDay({
      millis: millis
    });
  };

  exports.roundToHalfHour = function (inTime) {
    var isTimeOfDay = isTime(inTime),
        time = isTimeOfDay ? inTime : exports.makeTime(inTime),
        millis = time.getTimeOfDayMillis(),
        rounded = Math.round(millis / MILLIS_IN_HALF_HOUR) * MILLIS_IN_HALF_HOUR;
    rounded %= MILLIS_IN_DAY;
    return isTimeOfDay ? new TimeOfDay({
      millis: rounded
    }) : rounded;
  };

  return exports;
});
