/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['jquery'], function ($) {
  "use strict";
  /**
   * API Status: **Private**
   * @exports nmodule/schedule/rc/util/enclosingPoint
   */

  var exports = {};
  /**
   * jQuery custom selector that returns all elements whose boundaries
   * (calculated using <code>.offset()</code>, not <code>.position()</code>)
   * enclose the given coordinates. Installed using the standard
   * <code>$.expr[':'].enclosingPoint = enclosingPoint</code>
   */

  exports.enclosingPoint = function (elem, x, y) {
    //TODO: omg just use document.elementFromPoint you buffoon
    var pos = elem.offset();
    return y >= pos.top && y < pos.top + elem.height() && x >= pos.left && x < pos.left + elem.width();
  };

  $.expr.pseudos.enclosingPoint = $.expr.createPseudo(function (arg) {
    var params = arg.split(','),
        x = parseInt(params[0], 10),
        y = parseInt(params[1], 10);
    return function (elem) {
      return exports.enclosingPoint($(elem), x, y);
    };
  });
  return exports;
});
