function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'baja!schedule:CompositeSchedule,schedule:WeeklySchedule', 'Promise', 'underscore'], function (baja, types, Promise, _) {
  'use strict';

  function reject(err) {
    return Promise.reject(new Error(err));
  }
  /**
   * API Status: **Private**
   *
   * BajaScript server side call handlers for scheduling apps.
   *
   * @exports nmodule/schedule/rc/servlets/ssc
   */


  var exports = {};

  function doRpc(methodName, args, batch) {
    return baja.rpc({
      typeSpec: 'schedule:ScheduleRpc',
      method: methodName,
      args: _.map(args, function (arg) {
        return typeof arg === 'string' ? arg : JSON.stringify(baja.bson.encodeValue(arg));
      }),
      batch: batch
    });
  }

  function decodeScheduleBson(scheduleEnc) {
    var bson = JSON.parse(scheduleEnc);
    return baja.bson.importUnknownTypes(bson).then(function () {
      return baja.bson.decodeValue(bson);
    });
  }
  /**
   * Since schedules consist of huge trees of nested components, rather than
   * do a batch subscribe, this will ask the station to return a fully
   * populated schedule instance all in one shot.
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @param {baja.comm.Batch} [batch] Optional BajaScript batch object.
   * @returns {Promise} promise to be resolved with a complete, unmounted
   * snapshot of that schedule.
   */


  exports.getSnapshot = function (sourceOrd, batch) {
    return doRpc('getSnapshot', [String(sourceOrd)], batch).then(decodeScheduleBson);
  };
  /**
   * Apply the source schedule onto the target schedule. Properties will be
   * copied wholesale from the source onto the target. These properties
   * include:
   *
   * - All `TimeSchedule`s from a `WeeklySchedule`'s `week` configuration
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @param {baja.Component} schedule an unmounted schedule component
   * @returns {Promise} promise to be resolved when properties from
   * the source schedule are copied to the target schedule
   */


  exports.save = function (sourceOrd, schedule) {
    if (!baja.hasType(schedule, 'schedule:CompositeSchedule')) {
      return reject('CompositeSchedule required');
    }

    return doRpc('save', [String(sourceOrd), schedule]).then(decodeScheduleBson);
  };
  /**
   * Return a promise that resolves to an array of effective dates,
   * within a range, in ISO string format.
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @param {baja.Component} schedule a `schedule:AbstractSchedule` to test for
   * effective dates
   * @param {baja.Date} start start of range (inclusive)
   * @param {baja.Date} end end of range (exclusive)
   * @returns {Promise.<Array.<string>>} promise to be resolved with an array
   * of ISO date strings
   */


  exports.getHighlightedDates = function (sourceOrd, schedule, start, end) {
    return doRpc('getHighlightedDates', [String(sourceOrd), schedule, start, end]);
  };
  /**
   * Return a promise that resolves to the summary data for a particular schedule
   * between the specified dates.
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @param {baja.Component} schedule a `schedule:WeeklySchedule` to get
   * summary data for
   * @param {baja.Date} start start date (inclusive)
   * @param {baja.Date} end end date (exclusive)
   * @param {baja.Facets} facets facets for string formatting
   * @returns {Promise.<Array.<{ timestamp: string, output: string, source: string }>>}
   * promise to be resolved with an array of objects containing summary data.
   */


  exports.getSummary = function (sourceOrd, schedule, start, end, facets) {
    return doRpc('getSummary', [String(sourceOrd), schedule, start, end, facets]);
  };
  /**
   * Return a promise that resolves to the reference base ORD for the schedule.
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @param {baja.comm.Batch} [batch] Optional BajaScript batch object.
   * @returns {Promise<baja.Ord>} A promise that resolves to the
   * reference base ORD for a schedule.
   */


  exports.getRefBase = function (sourceOrd, batch) {
    return doRpc('getRefBase', [String(sourceOrd)], batch).then(function (ordStr) {
      return baja.Ord.make(ordStr);
    });
  };
  /**
   * Return a promise that resolves a list of ORDs. Each ORD maps
   * to a `schedule:CalendarSchedule`.
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @returns {Array<baja.Ord>} An array of ORDs
   */


  exports.findCalendarSchedules = function (sourceOrd) {
    return doRpc('findCalendarSchedules', [String(sourceOrd)]).then(function (ords) {
      return ords.map(function (o) {
        return baja.Ord.make(o);
      });
    });
  };
  /**
   * Returns a promise that resolves to number of options used to
   * load a schedule.
   *
   * @param  {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @param {baja.comm.Batch} [batch] Optional BajaScript batch object.
   * @returns {Object<String, String>} An array of schedule options.
   */


  exports.getScheduleOptions = function (sourceOrd, batch) {
    return doRpc('getScheduleOptions', [String(sourceOrd)], batch);
  };
  /**
   * Batch loads all of the initial schedule information into one network call.
   * This method will simultaneously invoke `getSnapshot`, `getRefBase` and `getScheduleOptions`.
   *
   * @param {baja.Ord|String} sourceOrd An ORD that resolves to the source
   * component for the view.
   * @returns {Object} An object with the resultant `snapshot`, `refBase`
   * and `options` properties.
   */


  exports.loadScheduleInfo = function (sourceOrd) {
    var batch = new baja.comm.Batch();
    return batch.commit(Promise.all([exports.getSnapshot(sourceOrd, batch), exports.getRefBase(sourceOrd, batch), exports.getScheduleOptions(sourceOrd, batch)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 3),
          snapshot = _ref2[0],
          refBase = _ref2[1],
          options = _ref2[2];

      return {
        snapshot: snapshot,
        refBase: refBase,
        options: options
      };
    }));
  };

  return exports;
});
