/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/model/WeekSchedule
 */
define(['nmodule/schedule/rc/model/DaySchedule'], function (DaySchedule) {
  'use strict';
  /**
   * Data model for the schedule for a full week.
   *
   * @class
   * @param {object} params
   * @alias module:nmodule/schedule/rc/model/WeekSchedule
   */

  var WeekSchedule = function WeekSchedule(params) {
    if (params instanceof WeekSchedule) {
      return params;
    }

    this.$daySchedules = (params && params.daySchedules || []).map(toDaySchedule);
  };
  /**
   * @returns {Array.<module:nmodule/schedule/rc/model/DaySchedule>}
   */


  WeekSchedule.prototype.getDaySchedules = function () {
    return this.$daySchedules;
  };

  function toDaySchedule(json) {
    return new DaySchedule(json);
  }

  return WeekSchedule;
});
