/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/model/DaySchedule
 */
define(['nmodule/schedule/rc/model/ScheduleBlock'], function (ScheduleBlock) {
  'use strict';
  /**
   * Data model for the schedule for a single day.
   *
   * @class
   * @alias module:nmodule/schedule/rc/model/DaySchedule
   * @param {object} params
   */

  var DaySchedule = function DaySchedule(params) {
    if (params instanceof DaySchedule) {
      return params;
    }

    if (!params || typeof params.dayOfWeek !== 'string') {
      throw new Error('day of week required');
    }

    this.$dayOfWeek = params.dayOfWeek;
    this.$blocks = (params.blocks || []).map(toScheduleBlock);
  };
  /**
   * @returns {string}
   */


  DaySchedule.prototype.getDayOfWeek = function () {
    return this.$dayOfWeek;
  };
  /**
   * @returns {Array.<module:nmodule/schedule/rc/model/ScheduleBlock>}
   */


  DaySchedule.prototype.getBlocks = function () {
    return this.$blocks;
  };

  DaySchedule.prototype.toJson = function () {
    return {
      dayOfWeek: this.$dayOfWeek,
      blocks: this.$blocks.map(function (b) {
        return b.toJson();
      })
    };
  };

  function toScheduleBlock(json) {
    return new ScheduleBlock(json);
  }

  return DaySchedule;
});
