/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/menu/CalendarEventsContextMenu
 */
define(['bajaux/commands/CommandGroup', 'nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu'], function (CommandGroup, CommandGroupContextMenu) {
  'use strict'; ////////////////////////////////////////////////////////////////
  // CalendarEventsContextMenu
  ////////////////////////////////////////////////////////////////

  /**
   * Context menu support for a `CalendarEventsEditor`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/menu/CalendarEventsContextMenu
   * @extends module:nmodule/webEditors/rc/wb/menu/CommandGroupContextMenu
   * @param {module:nmodule/schedule/rc/fe/CalendarEventsEditor} eventsEditor
   */

  var CalendarEventsContextMenu = function CalendarEventsContextMenu(eventsEditor) {
    CommandGroupContextMenu.apply(this, arguments);
  };

  CalendarEventsContextMenu.prototype = Object.create(CommandGroupContextMenu.prototype);
  CalendarEventsContextMenu.prototype.constructor = CalendarEventsContextMenu;
  /**
   * Assemble the appropriate `Command`s based on the editor commands that
   * are currently enabled.
   *
   * @returns {module:bajaux/commands/CommandGroup}
   */

  CalendarEventsContextMenu.prototype.toContextMenu = function () {
    return this.$ed.getCommandGroup().filter({
      include: function include(cmd) {
        return cmd.isEnabled();
      }
    });
  };
  /**
   * Arm a right click listener for the backing `CalendarEventsEditor`'s
   * table DOM.
   *
   * Context menu will appear only when right-clicking a `CalendarEventsEditor`
   *  table.
   */


  CalendarEventsContextMenu.prototype.arm = function () {
    return CommandGroupContextMenu.prototype.arm.call(this, {
      selector: '.tableContainer'
    });
  };

  return CalendarEventsContextMenu;
});
