/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/Scheduler
 */
define(['bajaux/events', 'bajaux/mixin/responsiveMixIn', 'bajaux/mixin/subscriberMixIn', 'bajaux/util/SaveCommand', 'nmodule/js/rc/log/Log', 'nmodule/schedule/rc/baja/fe/ActiveDatesCalendar', 'nmodule/schedule/rc/fe/CalendarEventsEditor', 'nmodule/schedule/rc/servlets/ssc', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (events, responsiveMixIn, subscribable, SaveCommand, Log, ActiveDatesCalendar, CalendarEventsEditor, ssc, scheduleUtils, CompositeEditor, CompositeBuilder) {
  'use strict';

  var MODIFY_EVENT = events.MODIFY_EVENT;

  var tpl = function tpl(ed) {
    return "\n    <div class=\"activeDates\"></div>\n    <div class=\"calendarScheduler\"></div>";
  };
  /**
   * Calendar Scheduler
   *
   * An editor that edits calendar events from a snapshot
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/CalendarScheduler
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   */


  var CalendarScheduler = function CalendarScheduler(params) {
    CompositeEditor.apply(this, arguments);
    this.getCommandGroup().add(new SaveCommand());
    subscribable(this);
    responsiveMixIn(this, {
      /* Hide the button descriptions when there's no longer any room */
      'calendar-scheduler-sm': {
        maxWidth: 410
      }
    });
  };

  CalendarScheduler.prototype = Object.create(CompositeEditor.prototype);
  CalendarScheduler.prototype.constructor = CalendarScheduler;

  CalendarScheduler.prototype.makeBuilder = function () {
    var _this = this;

    var builder = new CompositeBuilder();

    builder.getKeys = function () {
      return ['calendarScheduler', 'activeDates'];
    };

    builder.getDomFor = function (key) {
      return _this.jq().children('.' + key);
    };

    builder.getConfigFor = function (key) {
      switch (key) {
        case 'calendarScheduler':
          return {
            type: CalendarEventsEditor,
            properties: {
              includeReference: _this.$includeReference(),
              sourceOrd: _this.$sourceOrd
            }
          };

        case 'activeDates':
          return {
            properties: {
              refBase: _this.$refBase,
              sourceOrd: _this.$sourceOrd
            },
            type: ActiveDatesCalendar
          };
      }
    };

    builder.getValueFor = function (key) {
      switch (key) {
        case 'calendarScheduler':
        case 'activeDates':
          return _this.$snapshot;
      }
    };

    return builder;
  };
  /**
   * Return false not include ScheduleReference as an option when
   * adding a new Event. This prevents the CalendarScheduler from creating
   * a reference to itself.
   * @returns {boolean}
   * @private
   */


  CalendarScheduler.prototype.$includeReference = function () {
    return false;
  };

  CalendarScheduler.prototype.doInitialize = function (dom) {
    var _this2 = this;

    dom.addClass('CalendarScheduler').html(tpl(this));
    dom.on(MODIFY_EVENT, '.calendarScheduler', function () {
      _this2.setModified(true);

      return false;
    });
  };
  /**
   * @param {baja.Component} value a `schedule:CalendarSchedule`
   * @returns {Promise}
   */


  CalendarScheduler.prototype.doLoad = function (value) {
    var _this3 = this;

    var args = arguments;
    var navOrd = value.getNavOrd();
    return ssc.loadScheduleInfo(navOrd).then(function (_ref) {
      var snapshot = _ref.snapshot,
          refBase = _ref.refBase,
          options = _ref.options;
      _this3.$refBase = refBase;
      _this3.$snapshot = snapshot;
      _this3.$sourceOrd = navOrd;
      _this3.$options = options;
      return CompositeEditor.prototype.doLoad.apply(_this3, args);
    }).then(function () {
      _this3.$getCalendarEventsEditor().on('selectedEventChanged', function (event) {
        var sched = event || _this3.$getCalendarEventsEditor().value();

        _this3.$getActiveDatesCalendar().load(sched)["catch"](Log.error);
      });

      if (_this3.$options.readonly) {
        return _this3.setReadonly(true);
      }
    });
  };

  CalendarScheduler.prototype.doDestroy = function () {
    this.jq().removeClass('CalendarScheduler');
    return CompositeEditor.prototype.doDestroy.apply(this, arguments);
  };

  CalendarScheduler.prototype.$getActiveDatesCalendar = function () {
    return this.getBuilder().getEditorFor('activeDates');
  };

  CalendarScheduler.prototype.$getCalendarEventsEditor = function () {
    return this.getBuilder().getEditorFor('calendarScheduler');
  };

  CalendarScheduler.prototype.$doSaveCalendarEvents = function () {
    return this.$getCalendarEventsEditor().save();
  };

  CalendarScheduler.prototype.doSave = function () {
    var _this4 = this;

    return this.$doSaveCalendarEvents().then(function () {
      return ssc.save(_this4.value().getNavOrd(), _this4.$snapshot);
    });
  };

  return CalendarScheduler;
});
