function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'lex!schedule', 'nmodule/gx/rc/util/colorUtils'], function (baja, lexs, colorUtils) {
  'use strict';
  /**
   * API Status: **Private**
   * @exports nmodule/schedule/rc/baja/util/scheduleColorUtils
   */

  var exports = {};

  var _lexs = _slicedToArray(lexs, 1),
      scheduleLex = _lexs[0];

  var parseRgba = colorUtils.parseRgba;
  var DEFAULT_BACKGROUND = exports.DEFAULT_BACKGROUND = parseRgba('#8fbc8f');
  var FALSE_BACKGROUND = exports.FALSE_BACKGROUND = parseRgba('#e17171');
  var NULL_BACKGROUND = exports.NULL_BACKGROUND = parseRgba('#ccc');
  var TRUE_BACKGROUND = exports.TRUE_BACKGROUND = parseRgba('#65cb65');
  var DEFAULT_ENUM_COLORS = exports.DEFAULT_ENUM_COLORS = ["#8c0000", "#387038", "#703870", "#25255a", "#1f6f70", "#704308", "#606060", "#e17171", "#65cb65", "#cb7fcb", "#6c6ccb", "#54b7b8", "#c88435", "#e1e171"].map(parseRgba);
  /**
   * Calculate the desired value for a particular block on a `WeeklySchedule`,
   * based on the block's value and the configured facets.
   *
   * @param {baja.Facets} facets
   * @param {baja.Struct} statusValue a `baja:StatusValue`
   * @returns {Array.<number>} RGBA values [0 - 255]
   */

  exports.getStatusValueColor = function (facets, statusValue) {
    if (!baja.hasType(statusValue, 'baja:StatusValue')) {
      return DEFAULT_BACKGROUND;
    }

    switch (String(statusValue.getType())) {
      case 'baja:StatusBoolean':
        return getStatusBooleanColor(facets, statusValue);

      case 'baja:StatusEnum':
        return getStatusEnumColor(facets, statusValue);

      case 'baja:StatusNumeric':
        return getStatusNumericColor(facets, statusValue);

      case 'baja:StatusString':
        return getStatusStringColor(facets, statusValue);

      default:
        return DEFAULT_BACKGROUND;
    }
  };
  /**
   * @param {baja.Facets} facets facets with configuration info
   * @param {baja.Struct} statusBoolean a `baja:StatusBoolean`
   * @returns {Array.<number>} RGBA values
   */


  function getStatusBooleanColor(facets, statusBoolean) {
    if (isNull(statusBoolean)) {
      return getLexiconColor('BooleanSchedule.colors.null', NULL_BACKGROUND);
    }

    if (statusBoolean.get('value')) {
      return getConfiguredColor(facets, 1) || getLexiconColor('BooleanSchedule.colors.true', TRUE_BACKGROUND);
    } else {
      return getConfiguredColor(facets, 0) || getLexiconColor('BooleanSchedule.colors.false', FALSE_BACKGROUND);
    }
  }
  /**
   * @param {baja.Facets} facets with configuration info
   * @param {baja.Struct} statusEnum a `baja:StatusEnum`
   * @returns {Array.<number>} RGBA values
   */


  function getStatusEnumColor(facets, statusEnum) {
    if (isNull(statusEnum)) {
      return getLexiconColor('EnumSchedule.colors.null', NULL_BACKGROUND);
    }

    var i = getOrdinalIndex(facets, statusEnum.get('value'));
    return getConfiguredColor(facets, i) || getLexiconColor("EnumSchedule.colors.".concat(i), DEFAULT_ENUM_COLORS[i % DEFAULT_ENUM_COLORS.length]);
  }
  /**
   * @param {baja.Facets} facets with configuration info
   * @param {baja.Struct} statusNumeric a `baja:StatusNumeric`
   * @returns {Array.<number>} RGBA values
   */


  function getStatusNumericColor(facets, statusNumeric) {
    if (isNull(statusNumeric)) {
      return getLexiconColor('NumericSchedule.colors.null', NULL_BACKGROUND);
    }

    return getConfiguredColor(facets, 0) || getLexiconColor('NumericSchedule.colors.0', DEFAULT_BACKGROUND);
  }
  /**
   * @param {baja.Facets} facets with configuration info
   * @param {baja.Struct} statusString a `baja:StatusString`
   * @returns {Array.<number>} RGBA values
   */


  function getStatusStringColor(facets, statusString) {
    if (isNull(statusString)) {
      return getLexiconColor('StringSchedule.colors.null', NULL_BACKGROUND);
    }

    return getConfiguredColor(facets, 0) || getLexiconColor('StringSchedule.colors.0', DEFAULT_BACKGROUND);
  }
  /**
   * @param {baja.Facets} facets
   * @param {number} ordinal desired ordinal from configured colors
   * @returns {Array.<number>|null} RGBA values, or null if not configured
   */


  function getConfiguredColor(facets, ordinal) {
    try {
      var colors = facets.get('colors');

      if (baja.hasType(colors, 'baja:EnumRange')) {
        var tag = colors.get(ordinal).getTag();
        return parseRgba(baja.SlotPath.unescape(tag));
      }
    } catch (e) {
      return null;
    }
  }
  /**
   * @param {string} key
   * @param {Array.<number>} def default color to use if not in lexicon
   * @returns {Array.<number>} RGBA values parsed from lexicon
   */


  function getLexiconColor(key, def) {
    try {
      return parseRgba(scheduleLex.get(key));
    } catch (e) {
      return def;
    }
  }
  /**
   * @param {baja.Facets} facets facets with range - if no range, will use range
   * configured on enum directly
   * @param {baja.DynamicEnum} en
   * @returns {number} the index of the ordinal within the ordinals configured
   * on the enum range, or the ordinal itself if it's not in the range
   */


  function getOrdinalIndex(facets, en) {
    var ordinal = en.getOrdinal(),
        range = facets.get('range') || en.getRange(),
        i = range.getOrdinals().indexOf(ordinal);
    return i >= 0 ? i : ordinal;
  }

  function isNull(statusValue) {
    return statusValue.get('status').isNull();
  }

  return exports;
});
