function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'baja!schedule:DailySchedule,schedule:TimeSchedule,' + 'schedule:WeekSchedule,schedule:WeekdaySchedule', 'lex!baja', 'Promise', 'nmodule/schedule/rc/model/DaySchedule', 'nmodule/schedule/rc/model/ScheduleBlock', 'nmodule/schedule/rc/model/TimeOfDay', 'nmodule/schedule/rc/model/WeekSchedule', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils'], function (baja, types, lexs, Promise, DaySchedule, ScheduleBlock, TimeOfDay, WeekSchedule, scheduleUtils, facetsUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      bajaLex = _lexs[0],
      formatSimple = facetsUtils.formatSimple,
      getWeekdayIndex = scheduleUtils.getWeekdayIndex;

  var ScheduleTranslator = function ScheduleTranslator(facets) {
    this.$facets = facets;
  };

  ScheduleTranslator.prototype.toModel = function (obj) {
    var cx = this.$facets.toObject(),
        type = obj.getType();

    if (type.is('schedule:WeeklySchedule')) {
      return weeklyScheduleToModel(cx, obj);
    } else if (type.is('schedule:DailySchedule')) {
      return dailyScheduleToModel(cx, obj);
    } else if (type.is('schedule:TimeSchedule')) {
      return timeScheduleToModel(cx, obj);
    }
  };

  ScheduleTranslator.prototype.fromModel = function (model) {
    if (model instanceof TimeOfDay) {
      return timeOfDayToBajaTime(model);
    } else if (model instanceof ScheduleBlock) {
      return scheduleBlockToTimeSchedule(model);
    } else if (model instanceof DaySchedule) {
      return dayScheduleToDailySchedule(model);
    } else if (model instanceof WeekSchedule) {
      return weekScheduleToWeekSchedule(model);
    }
  };

  ScheduleTranslator.prototype.$toTimeRangeDisplay = function (start, finish, cx) {
    //TODO: there has to be a cleaner way to do this
    return toTimeRangeDisplay(start, finish, cx);
  };

  function dailyScheduleToModel(cx, dailySchedule) {
    var timeSchedules = dailySchedule.get('day').getSlots().is('schedule:TimeSchedule').toValueArray();
    return Promise.all(timeSchedules.map(timeScheduleToModel.bind(null, cx))).then(function (blocks) {
      return new DaySchedule({
        dayOfWeek: dailySchedule.getName(),
        blocks: blocks
      });
    });
  }
  /**
   * Accessor for facets.
   * @param {baja.Facets} [facets]
   * @returns {baja.Facets}
   */


  ScheduleTranslator.prototype.facets = function (facets) {
    if (facets !== undefined) {
      this.$facets = facets;
    }

    return this.$facets;
  };

  function timeScheduleToModel(cx, timeSchedule) {
    var start = new TimeOfDay(timeSchedule.get('start')),
        finish = new TimeOfDay(timeSchedule.get('finish')),
        effectiveValue = timeSchedule.get('effectiveValue'),
        display;

    if (baja.hasType(effectiveValue, 'baja:StatusValue')) {
      if (effectiveValue.get('status') === baja.Status.nullStatus) {
        display = bajaLex.get('Status.null');
      } else {
        //TODO: finish DynamicEnum#toString and chuck facetsUtils
        display = formatSimple(effectiveValue.get('value'), cx);
      }
    }

    return Promise.all([toTimeRangeDisplay(start, finish, cx), display]).spread(function (timeRangeDisplay, display) {
      return new ScheduleBlock({
        start: start,
        finish: finish,
        value: effectiveValue,
        timeRangeDisplay: timeRangeDisplay,
        valueDisplay: display
      });
    });
  }

  function weeklyScheduleToModel(cx, weeklySchedule) {
    var dailySchedules = weeklySchedule.get('schedule').get('week').getSlots().is('schedule:DailySchedule').toValueArray();
    return Promise.all(dailySchedules.map(dailyScheduleToModel.bind(null, cx))).then(function (daySchedules) {
      return new WeekSchedule({
        firstDayOfWeek: bajaLex.get('weekday.firstDayOfWeek'),
        daySchedules: daySchedules
      });
    });
  }

  function timeOfDayToBajaTime(timeOfDay) {
    return baja.Time.make(timeOfDay.getTimeOfDayMillis());
  }

  function scheduleBlockToTimeSchedule(block) {
    var value = block.getValue();

    if (!baja.hasType(value, 'baja:StatusValue')) {
      return Promise.reject(new Error('block value must be baja:StatusValue'));
    }

    var timeSchedule = baja.$('schedule:TimeSchedule', {
      start: timeOfDayToBajaTime(block.getStart()),
      finish: timeOfDayToBajaTime(block.getFinish()),
      effectiveValue: value.newCopy()
    }); //TODO: type extension? c.f. BAbstractSchedule#setEffectiveValue

    timeSchedule.setFlags({
      slot: 'effectiveValue',
      flags: baja.Flags.OPERATOR | baja.Flags.USER_DEFINED_1
    });
    return timeSchedule;
  }

  function dayScheduleToDailySchedule(daySchedule) {
    return Promise.all(daySchedule.getBlocks().map(scheduleBlockToTimeSchedule)).then(function (timeSchedules) {
      var ds = baja.$('schedule:DailySchedule', {
        days: baja.$('schedule:WeekdaySchedule', {
          set: baja.EnumSet.make([getWeekdayIndex(daySchedule.getDayOfWeek())])
        })
      }),
          day = ds.get('day');
      timeSchedules.forEach(function (ts) {
        day.add({
          slot: 'time?',
          value: ts
        });
      });
      return ds;
    });
  }

  function weekScheduleToWeekSchedule(weekSchedule) {
    var daySchedules = weekSchedule.getDaySchedules(),
        ws = baja.$('schedule:WeekSchedule');
    return Promise.all(daySchedules.map(dayScheduleToDailySchedule)).then(function (dailySchedules) {
      dailySchedules.forEach(function (dailySchedule, i) {
        ws.set({
          slot: daySchedules[i].getDayOfWeek(),
          value: dailySchedule
        });
      });
      return ws;
    });
  }

  function toTimeRangeDisplay(start, finish, cx) {
    return Promise.all([timeOfDayToBajaTime(start).toTimeString(cx), timeOfDayToBajaTime(finish).toTimeString(cx)]).spread(function (startString, finishString) {
      return startString + ' - ' + finishString;
    });
  }

  return ScheduleTranslator;
});
