/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'underscore', 'nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor', 'nmodule/schedule/rc/util/scheduleUtils'], function (baja, _, ScheduleEnumSetEditor, scheduleUtils) {
  'use strict';

  var toDayTags = scheduleUtils.toDayTags;
  /**
   * Editor for a `schedule:WeekdaySchedule`, which is an enum 0 - 6.
   *
   * @class
   * @alias module:nmodule/schedule/rc/baja/fe/WeekdayScheduleEnumSetEditor
   * @extends module:nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor
   */

  var WeekdayScheduleEnumSetEditor = function WeekdayScheduleEnumSetEditor() {
    ScheduleEnumSetEditor.apply(this, arguments);
  };

  WeekdayScheduleEnumSetEditor.prototype = Object.create(ScheduleEnumSetEditor.prototype);
  WeekdayScheduleEnumSetEditor.prototype.constructor = WeekdayScheduleEnumSetEditor;

  WeekdayScheduleEnumSetEditor.prototype.getEnumRange = function () {
    return toDayTags().then(function (tagsAndOrdinals) {
      var ordinals = _.pluck(tagsAndOrdinals, 'ordinal'),
          tags = _.pluck(tagsAndOrdinals, 'tag');

      return baja.EnumRange.make({
        ordinals: ordinals,
        tags: tags
      });
    });
  };

  return WeekdayScheduleEnumSetEditor;
});
