function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/TriggerTimesToAddEditor
 */
define(['baja!', 'lex!schedule', 'bajaux/events', 'Promise', 'nmodule/js/rc/log/Log', 'nmodule/schedule/rc/fe/templates', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor'], function (baja, lexs, events, Promise, Log, templates, ComplexCompositeEditor) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
      scheduleLex = _lexs[0],
      MODIFY_EVENT = events.MODIFY_EVENT,
      lexLabel = templates.lexLabel;

  var tpl = function tpl(ed) {
    return "\n    <div class=\"time\"></div>\n    <div class=\"isRange\"></div>\n    <table class=\"rangeInfo hide-table\">\n      <tr>\n        <td>".concat(lexLabel('trigger.rangeEnd'), "</td>\n        <td><span class=\"rangeEnd\"></span></td>\n      </tr>\n      <tr>\n        <td>").concat(lexLabel('trigger.rangeInterval'), "</td>\n        <td><span class=\"interval\"></span></td>\n      </tr>\n    </table>");
  };
  /**
   * Editor for the user-configurable settings for adding a time or range of
   * times to the list of trigger times on a `TriggerSchedule`.
   *
   * This editor expects a certain configured component to be loaded - when
   * calling `load()`, give it the result of
   * `TriggerTimesToAddEditor.makeComponent()`.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/schedule/rc/baja/fe/TriggerTimesToAddEditor
   */


  var TriggerTimesToAddEditor = function TimesToAddEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };

  TriggerTimesToAddEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  TriggerTimesToAddEditor.prototype.constructor = TriggerTimesToAddEditor;
  /**
   * @param {jQuery} dom
   * @returns {Promise}
   */

  TriggerTimesToAddEditor.prototype.doInitialize = function (dom) {
    var _this = this;

    dom.html(tpl(this));
    dom.on(MODIFY_EVENT, '.isRange', function (e, ed) {
      ed.read().then(function (isRange) {
        return Promise.all([_this.getBuilder().getEditorFor('rangeEnd').setEnabled(isRange), _this.getBuilder().getEditorFor('interval').setEnabled(isRange), _this.$showRange(isRange)]);
      })["catch"](Log.error);
    });
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  TriggerTimesToAddEditor.prototype.$showRange = function (show) {
    this.jq().find('.rangeInfo').toggleClass('hide-table', !show);
  };
  /**
   * Reads out the desired list of trigger times. If the range checkbox is not
   * checked, returns only the entered time; otherwise, calculates all trigger
   * times in the configured range.
   *
   * @returns {Promise.<Array.<baja.Time>>} times to add to the trigger list
   */


  TriggerTimesToAddEditor.prototype.doRead = function () {
    var builder = this.getBuilder(),
        keys = builder.getKeys();
    return Promise.all(keys.map(function (k) {
      return builder.getEditorFor(k).read();
    })).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 4),
          time = _ref2[0],
          isRange = _ref2[1],
          rangeEnd = _ref2[2],
          interval = _ref2[3];

      if (isRange) {
        return TriggerTimesToAddEditor.$getTriggerTimes(time, rangeEnd, interval);
      } else {
        return [time];
      }
    });
  };

  TriggerTimesToAddEditor.prototype.getSlotFilter = function () {
    return function (slot) {
      var config = {
        properties: {
          showSeconds: false
        }
      };

      switch (slot.getName()) {
        case 'rangeEnd':
        case 'interval':
          config.enabled = false;
          break;
      }

      return config;
    };
  };

  TriggerTimesToAddEditor.prototype.$buildSubEditorDom = function (key) {
    return this.jq().find('.' + key);
  };
  /**
   * Get all trigger times within the configured start, end, and repeat interval.
   *
   * @private
   * @param {baja.Time} startTime
   * @param {baja.Time} endTime (inclusive)
   * @param {baja.RelTime} interval
   * @returns {Array.<baja.Time>}
   */


  TriggerTimesToAddEditor.$getTriggerTimes = function (startTime, endTime, interval) {
    if (interval.getMillis() <= 0) {
      return [startTime];
    }

    var t = startTime,
        times = [];

    do {
      times.push(t);
      var next = plusInterval(t, interval);

      if (!next.isAfter(t)) {
        return times; //we've looped
      }

      t = next;
    } while (!t.isAfter(endTime));

    return times;
  };
  /**
   * @returns {baja.Component} a component to be loaded into this editor
   */


  TriggerTimesToAddEditor.makeComponent = function () {
    var comp = baja.$('baja:Component', {
      time: baja.Time.make({
        hour: 0,
        min: 0
      }),
      isRange: false,
      rangeEnd: baja.Time.make({
        hour: 23,
        min: 59
      }),
      interval: baja.RelTime.make({
        hours: 1
      })
    }),
        rangeText = scheduleLex.get('trigger.range');
    comp.setFacets({
      slot: 'isRange',
      facets: baja.Facets.make({
        trueText: rangeText,
        falseText: rangeText
      })
    });
    comp.setFacets({
      slot: 'interval',
      facets: baja.Facets.make({
        max: baja.RelTime.make({
          hours: 12
        }),
        min: baja.RelTime.make({
          hours: 0
        })
      })
    });
    return comp;
  }; //TODO: add to baja.Time


  function plusInterval(time, relTime) {
    return baja.Time.make(time.getTimeOfDayMillis() + relTime.getMillis());
  }

  return TriggerTimesToAddEditor;
});
