/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */
define(['baja!', 'underscore', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor'], function (baja, _, scheduleUtils, ScheduleEnumSetEditor) {
  'use strict';

  var toMonthTags = scheduleUtils.toMonthTags;
  /**
   * Editor for a `schedule:MonthSchedule.get('set')`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/MonthScheduleEnumSetEditor
   * @extends module:nmodule/webEditors/rc/fe/baja/EnumSetEditor
   */

  var MonthScheduleEnumSetEditor = function MonthScheduleEnumSetEditor() {
    ScheduleEnumSetEditor.apply(this, arguments);
  };

  MonthScheduleEnumSetEditor.prototype = Object.create(ScheduleEnumSetEditor.prototype);
  MonthScheduleEnumSetEditor.prototype.constructor = MonthScheduleEnumSetEditor;

  MonthScheduleEnumSetEditor.prototype.$isIncludeGroups = function () {
    return !!this.properties().getValue('includeGroups');
  };

  MonthScheduleEnumSetEditor.prototype.getEnumRange = function () {
    return toMonthTags(this.$isIncludeGroups()).then(function (tags) {
      return baja.EnumRange.make({
        ordinals: _.range(-1, tags.length - 1),
        tags: tags
      });
    });
  };

  MonthScheduleEnumSetEditor.prototype.isExclusiveSelection = function (idx) {
    return idx === 0 || idx > 12;
  };

  return MonthScheduleEnumSetEditor;
});
