/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/EnumSetScheduleEditor
 */
define(['baja!', 'Promise', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/baja/EnumSetEditor'], function (baja, Promise, ComplexCompositeEditor, EnumSetEditor) {
  'use strict'; //TODO: replicating Workbench behavior here - but is it even necessary? what blows up if the range is included?

  var OmitRangeEnumSetEditor = function OmitRangeEnumSetEditor() {
    EnumSetEditor.apply(this, arguments);
  };

  OmitRangeEnumSetEditor.prototype = Object.create(EnumSetEditor.prototype);
  OmitRangeEnumSetEditor.prototype.constructor = OmitRangeEnumSetEditor;

  OmitRangeEnumSetEditor.prototype.doRead = function () {
    return Promise.resolve(EnumSetEditor.prototype.doRead.apply(this, arguments)).then(function (enumSet) {
      return baja.EnumSet.make({
        ordinals: enumSet.getOrdinals()
      });
    });
  };
  /**
   * Editor for a `schedule:EnumSetSchedule`.
   *
   * @abstract
   * @class
   * @alias module:nmodule/schedule/rc/fe/EnumSetScheduleEditor
   * @extends {module:nmodule/webEditors/rc/fe/baja/EnumSetEditor}
   */


  var EnumSetScheduleEditor = function EnumSetScheduleEditor() {
    ComplexCompositeEditor.apply(this, arguments);
  };

  EnumSetScheduleEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  EnumSetScheduleEditor.prototype.constructor = EnumSetScheduleEditor;
  /**
   * Only the `set` property will be edited. When it is read back, the range
   * will not be included in the `EnumSet` since schedules do not use it
   * station-side.
   *
   * @returns {Function}
   */

  EnumSetScheduleEditor.prototype.getSlotFilter = function () {
    var that = this;
    return function (slot) {
      if (slot.getName() === 'set') {
        return {
          properties: {
            singleSelection: !!that.properties().getValue('singleSelection')
          },
          formFactor: that.getFormFactor(),
          type: OmitRangeEnumSetEditor
        };
      }
    };
  };
  /**
   * Ensure that whenever the `EnumSet` is loaded, the editor overrides it
   * using `$makeEnumSet` - so that it can use its own custom `EnumRange`.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/ComplexCompositeBuilder}
   */


  EnumSetScheduleEditor.prototype.makeBuilder = function () {
    var that = this,
        builder = ComplexCompositeEditor.prototype.makeBuilder.apply(this, arguments);

    builder.getValueFor = function (key) {
      var sched = this.getDataSource(),
          enumSet = sched.get(key);
      return that.$makeEnumSet(enumSet.getOrdinals());
    };

    return builder;
  };
  /**
   * Override this function to create the base `EnumSet` to load in. The
   * ordinals from the `EnumSet` being loaded will be passed in; combine these
   * with the appropriate `EnumRange`.
   *
   * @abstract
   * @param {Array.<Number>} ordinalsToLoad
   * @returns {baja.EnumSet|Promise}
   */


  EnumSetScheduleEditor.prototype.$makeEnumSet = function (ordinalsToLoad) {
    return baja.EnumSet.make({
      ordinals: ordinalsToLoad
    });
  };

  return EnumSetScheduleEditor;
});
