function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module  module:nmodule/xprotect/rc/xprotect/XProtectVideoStream
 */
define(['lex!videoDriver', 'log!nmodule.xprotect.rc.xprotect.XProtectVideoStream', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/fe/playback/PlaybackMixin', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/VideoFeedMixin', 'nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/xprotect/rc/xprotect/XProtectCamera', 'nmodule/xprotect/rc/xprotect/XProtectCameraSession', 'nmodule/xprotect/rc/xprotect/XProtectSession', 'nmodule/xprotect/rc/xprotect/xprotectUtils', 'css!nmodule/xprotect/rc/xprotect'], function (lexs, log, _, asyncUtils, PlaybackMixin, videoDriverUtils, VideoFeedMixin, StreamConfigurationMixin, rpc, BaseEditor, XProtectCamera, XProtectCameraSession, XProtectSession, xprotectUtils) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
      videoDriverLex = _lexs[0];

  var logFine = log.fine.bind(log);
  var logSevere = log.severe.bind(log);
  var CONNECTION_TIMEOUT_MILLIS = 10000;
  var isString = _.isString;
  var fitRatio = videoDriverUtils.fitRatio,
      getPlaybackSpeedFactor = videoDriverUtils.getPlaybackSpeedFactor;
  var getFps = xprotectUtils.getFps,
      getJpegCompressionLevel = xprotectUtils.getJpegCompressionLevel,
      getPixelMultiplier = xprotectUtils.getPixelMultiplier;
  var BANDWIDTH_DISPLAY_CHANGE_EVENT = StreamConfigurationMixin.BANDWIDTH_DISPLAY_CHANGE_EVENT;
  var CONNECTION_STATUS_CHANGED_EVENT = VideoFeedMixin.CONNECTION_STATUS_CHANGED_EVENT,
      STREAM_DATA_RECEIVED_EVENT = VideoFeedMixin.STREAM_DATA_RECEIVED_EVENT,
      TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;

  var tpl = function tpl() {
    return " <canvas class=\"canvasElement videoInsert\" />";
  };
  /**
   * Bajaux Widget for LiveVideo via XPMobileSDK
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @alias module:nmodule/xprotect/rc/xprotect/XProtectVideoStream
   * @implements module:nmodule/videoDriver/rc/fe/playback/PlaybackController
   * @mixes module:nmodule/videoDriver/rc/live/VideoFeedMixin
   * @mixes module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
   * @mixes module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
   */


  var XProtectVideoStream = /*#__PURE__*/function (_BaseEditor) {
    _inherits(XProtectVideoStream, _BaseEditor);

    var _super = _createSuper(XProtectVideoStream);

    function XProtectVideoStream() {
      var _this;

      _classCallCheck(this, XProtectVideoStream);

      _this = _super.apply(this, arguments);
      PlaybackMixin(_assertThisInitialized(_this));
      StreamConfigurationMixin(_assertThisInitialized(_this));
      VideoFeedMixin(_assertThisInitialized(_this));
      return _this;
    }
    /**
     * @param {JQuery} dom
     * @returns {Promise}
     */


    _createClass(XProtectVideoStream, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl());
        dom.addClass('XProtectVideoStream');
      }
      /**
       * @param {baja.Component} value - a `nvideo:VideoCamera` instance
       * @param {object} [params]
       * @param {boolean} [params.fullLoad] if true, the camera must be fully
       * connected, logged in, and streaming before `load()` will resolve.
       * Otherwise, the widget will show the connecting/logging-in process to the
       * user.
       * @returns {Promise}
       */

    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
            fullLoad = _ref.fullLoad;

        // don't wait for the camera to initialize - just kick it off. this will
        // allow the widget to display while the "connected" and "logged in"
        // status updates come through.
        var promise = this.$initializeCamera(value)["catch"](logSevere);
        this.$cameraInitialized = promise;

        if (fullLoad) {
          return promise;
        }
      }
      /**
       * Updates the dimensions of the video stream to match the dimensions of
       * the widget.
       */

    }, {
      key: "doLayout",
      value: function doLayout() {
        var camera = this.$camera;

        if (!camera) {
          return;
        }

        return camera.changeStream(this.$getFitDimensions(this.value()));
      }
      /**
       * Get a reference to the loaded XProtect camera and get it ready for
       * streaming.
       *
       * @private
       * @returns {Promise}
       */

    }, {
      key: "$initializeCamera",
      value: function $initializeCamera(camera) {
        var _this2 = this;

        var cameraId = 0,
            cameraType = camera.getType(); // Conditional check for camera id as
        // MilestoneCamera's id is stored in cameraGuid and
        // XProtectCamera's id is stored in cameraId.

        if (cameraType.is('nmilestone:MilestoneCamera')) {
          cameraId = camera.get('videoDeviceId').get('cameraGuid');
        } else if (cameraType.is('xprotect:XProtectCamera')) {
          cameraId = camera.get('videoDeviceId').get('cameraId');
        }

        return rpc.getConnectionParams(camera).then(function (_ref2) {
          var uri = _ref2.uri,
              username = _ref2.username,
              password = _ref2.password;
          return XProtectSession.connect({
            url: uri,
            username: username,
            password: password,
            onStatusChanged: function onStatusChanged(status) {
              return _this2.$setVideoConnectionStatus(status);
            }
          });
        }).then(function (session) {
          var jq = _this2.jq();

          var canvas = jq.find('.canvasElement');

          var _this2$$getFitDimensi = _this2.$getFitDimensions(camera),
              width = _this2$$getFitDimensi.width,
              height = _this2$$getFitDimensi.height;

          var cameraSession = new XProtectCameraSession({
            session: session,
            cameraId: cameraId,
            streamProperties: {
              width: width,
              height: height,
              compressionLevel: _this2.$getCompression(),
              fps: _this2.$getFps(),
              pixelMultiplier: _this2.$getPixelMultiplier()
            }
          });
          cameraSession.on(XProtectCameraSession.TIMESTAMP_EVENT, function (timestamp) {
            _this2.$setVideoTimestamp(timestamp); //wait for the first timestamp update to know we are fully successful


            _this2.$setVideoConnectionStatus(XProtectSession.CONNECTION_SUCCESSFUL);
          });
          cameraSession.on(XProtectCameraSession.BANDWIDTH_EVENT, function (display) {
            return _this2.emit(BANDWIDTH_DISPLAY_CHANGE_EVENT, display);
          });
          _this2.$camera = new XProtectCamera({
            cameraSession: cameraSession,
            canvas: canvas
          });
        });
      }
      /**
       * Given the camera's preferred aspect ratio, get the correct dimensions to
       * initialize the camera stream to maximize the space in this widget's DOM
       * element.
       *
       * @private
       * @param {baja.Component} camera a `videoDriver:VideoCamera`
       * @returns {{width: number, height: number}}
       */

    }, {
      key: "$getFitDimensions",
      value: function $getFitDimensions(camera) {
        var jq = this.jq();
        var canvas = this.jq().find('.canvasElement');
        var aspectRatio = camera.get('videoPreferences').get('preferredAspectRatio'); // a canvas won't scale down, which can inflate the calculated dimensions.
        // so hide it while we calculate.

        canvas.hide(); // if css rules mean the dom has an area of 0, default to 320x240 so we
        // can display *something*

        var videoContainer = jq.closest('.videoContainer');
        var width = videoContainer.width() || jq.width() || 320;
        var height = videoContainer.height() || jq.height() || 240;
        canvas.show();
        return fitRatio(aspectRatio, {
          width: width,
          height: height
        });
      }
    }, {
      key: "$getFps",
      value: function $getFps() {
        var preferredFrameRate = this.$getPreference('preferredFrameRate');
        return getFps(preferredFrameRate);
      }
    }, {
      key: "$getCompression",
      value: function $getCompression() {
        var preferredCompression = this.$getPreference('preferredCompression');
        return getJpegCompressionLevel(preferredCompression);
      }
    }, {
      key: "$getPixelMultiplier",
      value: function $getPixelMultiplier() {
        var preferredResolution = this.$getPreference('preferredResolution');
        return getPixelMultiplier(preferredResolution);
      }
    }, {
      key: "$getPreference",
      value: function $getPreference(name) {
        var camera = this.value();
        return camera.get('videoPreferences').get(name);
      }
      /**
       * @returns {number}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */

    }, {
      key: "getVideoTimestamp",
      value: function getVideoTimestamp() {
        return this.$lastTimestamp;
      }
      /**
       * Sets current video timestamp and emits `TIMESTAMP_CHANGED_EVENT`. Also
       * emits `STREAM_DATA_RECEIVED_EVENT` because in Milestone, every video
       * frame comes with a timestamp whether in playback mode or not.
       * @private
       * @param {number} timestamp
       */

    }, {
      key: "$setVideoTimestamp",
      value: function $setVideoTimestamp(timestamp) {
        this.$lastTimestamp = timestamp;
        this.emit(STREAM_DATA_RECEIVED_EVENT);
        this.emit(TIMESTAMP_CHANGED_EVENT);
      }
      /**
       * @returns {String}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */

    }, {
      key: "getVideoConnectionStatus",
      value: function getVideoConnectionStatus() {
        return this.$videoConnectionStatus;
      }
      /**
       * Sets current connection status and fires `CONNECTION_STATUS_CHANGED_EVENT`
       * (possibly asynchronously).
       * @private
       * @param {String} status
       * @returns {Promise|*}
       */

    }, {
      key: "$setVideoConnectionStatus",
      value: function $setVideoConnectionStatus(status) {
        var _this3 = this;

        if (status === XProtectSession.READY_FOR_VIDEO) {
          return asyncUtils.waitInterval(CONNECTION_TIMEOUT_MILLIS).then(function () {
            if (!_this3.$lastTimestamp) {
              _this3.$setVideoConnectionStatus(XProtectSession.CONNECTION_TIMED_OUT);
            }
          });
        }

        this.$videoConnectionStatus = videoDriverLex.get(status);
        this.emit(CONNECTION_STATUS_CHANGED_EVENT);
      }
      /**
       * @returns {boolean}
       * @see module:nmodule/videoDriver/rc/live/VideoFeedMixin
       */

    }, {
      key: "isVideoStreaming",
      value: function isVideoStreaming() {
        return !!this.$lastTimestamp;
      }
      /**
       * Closes the camera connection.
       * @returns {*}
       */

    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var camera = this.$camera;

        if (camera) {
          camera.destroy();
        }

        return this.getChildEditors().destroyAll();
      }
      /**
       * @returns {baja.Component} the currently loaded camera
       * @see module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
       */

    }, {
      key: "getCamera",
      value: function getCamera() {
        return this.value();
      }
      /**
       * Change the current playback type and speed.
       * @param {object} params
       * @param {string} [params.type] a `BPlaybackTypeEnum` tag
       * @param {number} [params.speed] playback speed, from 1 to 10
       * @see module:nmodule/videoDriver/rc/fe/playback/PlaybackMixin
       */

    }, {
      key: "doPlayback",
      value: function doPlayback(_ref3) {
        var _this4 = this;

        var type = _ref3.type,
            speed = _ref3.speed,
            timestamp = _ref3.timestamp;
        logFine("XProtectVideoStream#playback - type: ".concat(type, ", speed: ").concat(speed));
        this.$cameraInitialized.then(function () {
          var camera = _this4.$camera;

          if (type === 'live') {
            return camera.live();
          } else {
            return camera.play({
              speed: getPlaybackSpeedFactor(type, speed),
              timestamp: timestamp
            });
          }
        })["catch"](logSevere);
      }
      /**
       * @param {module:nmodule/videoDriver/rc/live/stream/StreamSettings} settings
       * @see module:nmodule/videoDriver/rc/live/stream/StreamConfigurationMixin
       */

    }, {
      key: "applyStreamSettings",
      value: function applyStreamSettings() {
        var _this5 = this;

        var settings = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var preferredResolution = settings.preferredResolution,
            preferredFrameRate = settings.preferredFrameRate,
            preferredCompression = settings.preferredCompression;
        var streamProperties = {};

        if (isString(preferredResolution)) {
          streamProperties.pixelMultiplier = getPixelMultiplier(preferredResolution);
        }

        if (isString(preferredFrameRate)) {
          streamProperties.fps = getFps(preferredFrameRate);
        }

        if (isString(preferredCompression)) {
          streamProperties.compressionLevel = getJpegCompressionLevel(preferredCompression);
        }

        return this.$cameraInitialized.then(function () {
          var camera = _this5.$camera;
          return camera && camera.changeStream(streamProperties);
        });
      }
    }]);

    return XProtectVideoStream;
  }(BaseEditor);

  return XProtectVideoStream;
});
