function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/* eslint-disable promise/avoid-new */

/* global XPMobileSDK, XPMobileSDKSettings */

/**
 * API Status: **Private**
 * @module nmodule/xprotect/rc/xprotect/XProtectSession
 */
define(['log!nmodule.xprotect.rc.xprotect.XProtectSession', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/tinyevents/tinyevents'], function (log, Promise, _, asyncUtils, tinyevents) {
  'use strict';

  var logFine = log.fine.bind(log);
  var logSevere = log.severe.bind(log);
  var doRequire = asyncUtils.doRequire;
  var extend = _.extend,
      isNumber = _.isNumber,
      isString = _.isString,
      noop = _.noop;
  var SDK_MODULE_ID = 'nmodule/xprotect/ext/sdk/XPMobileSDK';
  var DEFAULT_FPS = 10;
  var DEFAULT_COMPRESSION_LEVEL = 75;
  var STATUS_CHANGED = 'statuschanged';
  var CONNECTION_IN_PROGRESS = 'connection.inProgress';
  var CONNECTION_FAILED = 'connection.failed';
  var CONNECTION_LOST = 'connection.lost';
  var CONNECTION_DISCONNECTING = 'connection.disconnecting';
  var CONNECTION_DISCONNECTED = 'connection.disconnected';
  var CONNECTION_TIMED_OUT = 'connection.timeout';
  var LOGIN_FAILED = 'connection.loginFailed';
  var READY_FOR_VIDEO = 'connection.waitingForVideo';
  var CONNECTION_SUCCESSFUL = 'connection.successful';
  var VALID_PTZ_POSITIONS = ['Up', 'Right', 'Down', 'Left', 'UpRight', 'UpLeft', 'DownRight', 'DownLeft', 'Home', 'ZoomIn', 'ZoomOut'];
  var lastUrl;
  var lastUsername;
  var lastPassword;
  var instancePromise;
  /**
   * This class establishes one global connection to the XProtect server.
   *
   * @class
   * @alias module:nmodule/xprotect/rc/xprotect/XProtectSession
   * @mixes tinyevents
   */

  return /*#__PURE__*/function () {
    /**
     * Not to be called directly. Use the static `make()` method instead.
     */
    function XProtectSession() {
      _classCallCheck(this, XProtectSession);

      tinyevents(this);
      this.$observers = {};
    }
    /**
     * Event name for when the connection status changes. Argument to the event
     * handler will be a string indicating the connection status.
     * @type {string}
     */


    _createClass(XProtectSession, [{
      key: "$connect",

      /**
       * @private
       * @param {string} url
       * @param {string} username
       * @param {string} password
       * @returns {Promise}
       */
      value: function $connect(_ref) {
        var _this = this;

        var url = _ref.url,
            username = _ref.username,
            password = _ref.password;
        return this.$connectToUrl(url).then(function () {
          return _this.$login(username, password);
        });
      }
      /**
       * Releases resources held by this session. Only to be used internally when
       * an existing session is torn down before opening a new one.
       *
       * @private
       */

    }, {
      key: "$destroy",
      value: function $destroy() {
        var sdk = this.$sdk;
        sdk.removeObserver(this.$observers);
        sdk.disconnect();
        sdk.destroy();
        this.removeAllListeners(); // This will remove the XPMobileSDK from require cache, so that it can be re-required again.
        // Only after re-requiring, the Milestone lifecycle methods trigger.

        require.undef(SDK_MODULE_ID);
      }
      /**
       * @param {string} cameraId
       * @returns {Promise.<object[]>}
       */

    }, {
      key: "getPresets",
      value: function getPresets(cameraId) {
        var _this2 = this;

        return new Promise(function (resolve, reject) {
          _this2.$sdk.getPtzPresets(cameraId, resolve, reject);
        });
      }
      /**
       * Request a new video stream.
       *
       * @param {object} params
       * @param {string} params.cameraId
       * @param {number} [params.timestamp] specify a time to play from
       * @param {module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties} streamProperties the
       * initial properties of the stream
       * @returns {{ resolveVideoConnection: Function, cancelRequest: Function }} call `resolveVideoConnection()` to
       * get a Promise that resolves to the `VideoConnection` for the new stream,
       * or call `cancelRequest` to cancel the pending request
       */

    }, {
      key: "requestStream",
      value: function requestStream(_ref2) {
        var cameraId = _ref2.cameraId,
            timestamp = _ref2.timestamp,
            streamProperties = _ref2.streamProperties;

        if (!cameraId) {
          throw new Error('cameraId required');
        }

        var width = streamProperties.width,
            height = streamProperties.height,
            _streamProperties$sig = streamProperties.signalType,
            signalType = _streamProperties$sig === void 0 ? 'Live' : _streamProperties$sig,
            _streamProperties$com = streamProperties.compressionLevel,
            compressionLevel = _streamProperties$com === void 0 ? DEFAULT_COMPRESSION_LEVEL : _streamProperties$com,
            _streamProperties$fps = streamProperties.fps,
            fps = _streamProperties$fps === void 0 ? DEFAULT_FPS : _streamProperties$fps;

        if (!width) {
          throw new Error('width required');
        }

        if (!height) {
          throw new Error('height required');
        }

        var sdk = this.$sdk;
        var request = null;
        var promise = new Promise(function (resolve, reject) {
          // TODO: write up SDK deficiencies and provide to Milestone.
          // much of this is copy-pasted and tweaked from Connection.js because:
          // sdk.requestStream would avoid a lot of this cruft, but won't allow
          // you to specify Fps, and sdk.RequestStream won't return the stream
          // request object so neither one actually works.
          var Connection = sdk.library.Connection;
          var params = {
            CameraId: cameraId,
            DestWidth: Math.round(width),
            DestHeight: Math.round(height),
            SignalType: signalType,
            MethodType: Connection.webSocketServer && Connection.webSocketBrowser ? 'Push' : 'Pull',
            Fps: fps,
            ComprLevel: compressionLevel,
            KeyFramesOnly: 'No',
            RequestSize: 'Yes',
            StreamType: 'Transcoded'
          };

          if (timestamp && signalType === 'Playback') {
            params.SeekType = 'Time'; // "time" is used as the start time of playback stream, it is required as a parameter in XPMobileSDK.VideoConnectionOptions

            params.time = timestamp; // "Time" is used as the time of playback speed , it is required as a parameter for the RequestStream method of XPMobileSDK

            params.Time = timestamp;
          }

          if (sdk.features.SupportNoScaledImages) {
            params.ResizeAvailable = 'Yes';
          }

          logFine('Requesting Stream: ' + JSON.stringify(params));
          request = Connection.RequestStream(params, resolve, reject);
        });

        request.resolveVideoConnection = function () {
          return promise;
        };

        request.cancelRequest = function () {
          return sdk.cancelRequest(request);
        };

        return request;
      }
      /**
       * Change the properties of an ongoing stream.
       *
       * @param {object} params
       * @param {string} params.videoId
       * @param {module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties} params.streamProperties
       * @returns {Promise}
       */

    }, {
      key: "changeStream",
      value: function changeStream(_ref3) {
        var _this3 = this;

        var videoId = _ref3.videoId,
            _ref3$streamPropertie = _ref3.streamProperties,
            streamProperties = _ref3$streamPropertie === void 0 ? {} : _ref3$streamPropertie;
        var params = {
          VideoId: videoId
        };
        var compressionLevel = streamProperties.compressionLevel,
            fps = streamProperties.fps,
            signalType = streamProperties.signalType,
            width = streamProperties.width,
            height = streamProperties.height;

        if (isNumber(width)) {
          params.DestWidth = Math.floor(width);
        }

        if (isNumber(height)) {
          params.DestHeight = Math.floor(height);
        }

        if (isNumber(compressionLevel)) {
          params.ComprLevel = compressionLevel;
        }

        if (isNumber(fps)) {
          params.Fps = fps;
        }

        if (isString(signalType)) {
          params.SignalType = signalType;
        }

        return new Promise(function (resolve, reject) {
          logFine('Changing Stream: ' + JSON.stringify(params));

          _this3.$sdk.ChangeStream(params, resolve, reject);
        });
      }
      /**
       * Change the playback speed of a video connection.
       *
       * @param {VideoConnection} videoConnection a `VideoConnection` resolved
       * from a `requestStream` call
       * @param {number} speed
       * @returns {ConnectionRequest}
       */

    }, {
      key: "setPlaybackSpeed",
      value: function setPlaybackSpeed(videoConnection, speed) {
        if (!videoConnection) {
          throw new Error('VideoConnection required');
        }

        if (!isNumber(speed)) {
          throw new Error('speed required');
        }

        return this.$sdk.playbackSpeed(videoConnection, speed);
      }
      /**
       * Perform a pan/tilt/zoom.
       *
       * @param {VideoConnection} videoConnection a `VideoConnection` resolved
       * from a `requestStream` call
       * @param {string} direction
       * @returns {ConnectionRequest}
       */

    }, {
      key: "ptz",
      value: function ptz(videoConnection, direction) {
        if (!videoConnection) {
          throw new Error('VideoConnection required');
        }

        if (!_.contains(VALID_PTZ_POSITIONS, direction)) {
          throw new Error('invalid direction ' + direction);
        }

        return this.$sdk.ptzMove(videoConnection, direction);
      }
      /**
       * Get current configured resampling factor.
       *
       * @returns {number}
       */

    }, {
      key: "getResamplingFactor",
      value: function getResamplingFactor() {
        return this.$sdk.getResamplingFactor();
      }
      /**
       * @private
       * @param {object} observers
       */

    }, {
      key: "$addObservers",
      value: function $addObservers(observers) {
        this.$sdk.addObserver(observers);
        extend(this.$observers, observers);
      }
      /**
       * @private
       * @param {string} url
       * @returns {Promise}
       */

    }, {
      key: "$connectToUrl",
      value: function $connectToUrl(url) {
        var _this4 = this;

        var sdk = this.$sdk;
        sdk.library.Connection.server = url; //TODO: is there a public API i can use instead?

        XPMobileSDKSettings.MobileServerURL = url;
        return new Promise(function (resolve, reject) {
          _this4.$addObservers({
            connectionDidConnect: function connectionDidConnect() {
              //login will change this later
              _this4.$setStatus(CONNECTION_IN_PROGRESS);

              resolve();
            },
            connectionFailedToConnect: function connectionFailedToConnect(error) {
              _this4.$setStatus(CONNECTION_FAILED);

              reject(error);
            },
            connectionLostConnection: function connectionLostConnection() {
              return _this4.$setStatus(CONNECTION_LOST);
            },
            connectionProcessingDisconnect: function connectionProcessingDisconnect() {
              return _this4.$setStatus(CONNECTION_DISCONNECTING);
            },
            connectionDidDisconnect: function connectionDidDisconnect() {
              return _this4.$setStatus(CONNECTION_DISCONNECTED);
            }
          });

          _this4.$setStatus(CONNECTION_IN_PROGRESS);

          sdk.Connect(null, null, function (error) {
            _this4.$setStatus(CONNECTION_FAILED);

            reject(error);
          });
        });
      }
      /**
       * @private
       * @param {string} username
       * @param {string} password
       * @returns {Promise}
       */

    }, {
      key: "$login",
      value: function $login(username, password) {
        var _this5 = this;

        return new Promise(function (resolve, reject) {
          _this5.$addObservers({
            connectionDidLogIn: function connectionDidLogIn() {
              //since login is the last step, we will use that as connected
              //this.$setStatus('connection.successful');
              _this5.$setStatus(READY_FOR_VIDEO);

              resolve();
            },
            connectionFailedToLogIn: function connectionFailedToLogIn(error) {
              _this5.$setStatus(LOGIN_FAILED);

              reject(error);
            }
          });

          _this5.$sdk.login(username, password);
        });
      }
      /**
       * @private
       * @param {string} status
       */

    }, {
      key: "$setStatus",
      value: function $setStatus(status) {
        this.emit(XProtectSession.STATUS_CHANGED_EVENT, status);
      }
      /**
       * @private
       * @returns {Promise}
       */

    }], [{
      key: "$make",

      /**
       * @private
       * @returns {Promise.<module:nmodule/xprotect/rc/xprotect/XProtectSession>}
       */
      value: function $make() {
        return XProtectSession.$loadSdk().then(function (sdk) {
          var conn = new XProtectSession();
          conn.$sdk = sdk;
          return conn;
        });
      }
      /**
       * Create an `XProtectSession` instance, logged into to the given server.
       * If an existing session is open, with the same URL and credentials, it
       * will simply be reused instead of negotiating a new connection.
       *
       * // TODO: log out after (5?) minutes of no activity
       *
       * @param {object} params
       * @param {string} params.url
       * @param {string} params.username
       * @param {string} params.password
       * @returns {Promise.<module:nmodule/xprotect/rc/xprotect/XProtectSession>}
       */

    }, {
      key: "connect",
      value: function connect(_ref4) {
        var url = _ref4.url,
            username = _ref4.username,
            password = _ref4.password,
            _ref4$onStatusChanged = _ref4.onStatusChanged,
            onStatusChanged = _ref4$onStatusChanged === void 0 ? noop : _ref4$onStatusChanged;

        if (url === lastUrl && username === lastUsername && password === lastPassword) {
          onStatusChanged(READY_FOR_VIDEO);
          return instancePromise;
        }

        lastUrl = url;
        lastUsername = username;
        lastPassword = password;
        instancePromise = Promise.resolve(instancePromise).then(function (existing) {
          return existing && existing.$destroy();
        }).then(XProtectSession.$make).then(function (newInstance) {
          newInstance.on(XProtectSession.STATUS_CHANGED_EVENT, onStatusChanged);
          return newInstance.$connect({
            url: url,
            username: username,
            password: password
          }).then(function () {
            return newInstance;
          });
        })["catch"](function (err) {
          instancePromise = lastUrl = lastUsername = lastPassword = null;
          logSevere(err);
          throw err;
        });
        return instancePromise;
      }
    }, {
      key: "$loadSdk",
      value: function $loadSdk() {
        if (require.defined(SDK_MODULE_ID)) {
          return Promise.resolve(require(SDK_MODULE_ID));
        }

        return doRequire(SDK_MODULE_ID).then(function () {
          return new Promise(function (resolve) {
            XPMobileSDKSettings.includes = ['/module/xprotect/ext/sdk/XPMobileSDK.library.js'];

            XPMobileSDK.onLoad = function () {
              return resolve(XPMobileSDK);
            };
          });
        });
      }
    }, {
      key: "STATUS_CHANGED_EVENT",
      get: function get() {
        return STATUS_CHANGED;
      }
      /**
       * Connection process has begun.
       * @type {string}
       */

    }, {
      key: "CONNECTION_IN_PROGRESS",
      get: function get() {
        return CONNECTION_IN_PROGRESS;
      }
      /**
       * Failed to connect.
       * @type {string}
       */

    }, {
      key: "CONNECTION_FAILED",
      get: function get() {
        return CONNECTION_FAILED;
      }
      /**
       * Connection was lost.
       * @type {string}
       */

    }, {
      key: "CONNECTION_LOST",
      get: function get() {
        return CONNECTION_LOST;
      }
      /**
       * Connection has begun to disconnect.
       * @type {string}
       */

    }, {
      key: "CONNECTION_DISCONNECTING",
      get: function get() {
        return CONNECTION_DISCONNECTING;
      }
      /**
       * Connection finished disconnecting.
       * @type {string}
       */

    }, {
      key: "CONNECTION_DISCONNECTED",
      get: function get() {
        return CONNECTION_DISCONNECTED;
      }
      /**
       * Connection timed out (connection was successful, but no video data was
       * received in time).
       * @type {string}
       */

    }, {
      key: "CONNECTION_TIMED_OUT",
      get: function get() {
        return CONNECTION_TIMED_OUT;
      }
      /**
       * Login failed due to incorrect credentials or otherwise.
       * @type {string}
       */

    }, {
      key: "LOGIN_FAILED",
      get: function get() {
        return LOGIN_FAILED;
      }
      /**
       * Connection and login were successful and we are now waiting for video
       * data to arrive to the client.
       * @type {string}
       */

    }, {
      key: "READY_FOR_VIDEO",
      get: function get() {
        return READY_FOR_VIDEO;
      }
      /**
       * Connection and login were successful, and we started receiving video data
       * before the timeout.
       * @type {string}
       */

    }, {
      key: "CONNECTION_SUCCESSFUL",
      get: function get() {
        return CONNECTION_SUCCESSFUL;
      }
    }]);

    return XProtectSession;
  }();
});
/**
 * @typedef {object} module:nmodule/xprotect/rc/xprotect/XProtectSession~StreamProperties
 * @property {number} [width] - stream width
 * @property {number} [height] - stream height
 * @property {number} [compressionLevel] - JPEG compression level of stream data
 * @property {number} [pixelMultiplier] - set to 2, 4 etc. to make pixels bigger and
 * use less bandwidth
 * @property {number} [fps] - frame rate of stream
 * @property {string} [signalType] - either `Live` or `Playback`
 */
