/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/MinMaxAvg
 */
define(['baja!', 'nmodule/kitControl/rc/baja/util/DecaInputNumeric', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, DecaInputNumeric, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:MinMaxAvg` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/util/DecaInputNumeric}
   * @alias {module:nmodule/kitControl/rc/baja/util/MinMaxAvg}
   */

  var MinMaxAvg = function MinMaxAvg() {
    DecaInputNumeric.apply(this, arguments);
    proxySlotFacets(this, {
      '^(min|max|avg)$': 'facets'
    });
  };

  MinMaxAvg.prototype = Object.create(DecaInputNumeric.prototype);
  MinMaxAvg.prototype.constructor = MinMaxAvg;
  return MinMaxAvg;
});
