/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/Latch
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:Latch` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/util/Latch}
   */

  var Latch = function Latch() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out': 'facets'
    });
  };

  Latch.prototype = Object.create(Component.prototype);
  Latch.prototype.constructor = Latch;
  return Latch;
});
