/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/EnumSwitch
 */
define(['baja!', 'baja!control:EnumPoint', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, types, bajaUtils) {
  'use strict';

  var EnumPoint = baja.findCtor('control:EnumPoint'),
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:EnumSwitch` value.
   *
   * @class
   * @extends {module:baja/comp/ControlPoint}
   * @alias {module:nmodule/kitControl/rc/baja/util/EnumSwitch}
   */

  var EnumSwitch = function EnumSwitch() {
    EnumPoint.apply(this, arguments);
    proxySlotFacets(this, {
      '^in': 'facets'
    });
  };

  EnumSwitch.prototype = Object.create(EnumPoint.prototype);
  EnumSwitch.prototype.constructor = EnumSwitch;
  return EnumSwitch;
});
