/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/util/DigitalInputDemux
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets,
      propagateFacets = baja.Facets.make({
    fieldEditor: 'kitControl:PropagateFlagsFE',
    uxFieldEditor: 'kitControl:PropagateFlagsEditor'
  });
  /**
   * BajaScript representation of a `kitControl:DigitalInputDemux` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/util/DigitalInputDemux}
   */

  var DigitalInputDemux = function DigitalInputDemux() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^propagateFlags$': propagateFacets
    });
  };

  DigitalInputDemux.prototype = Object.create(Component.prototype);
  DigitalInputDemux.prototype.constructor = DigitalInputDemux;
  return DigitalInputDemux;
});
