/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/timer/CurrentTime
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:CurrentTime` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/timer/CurrentTime}
   */

  var CurrentTime = function CurrentTime() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  CurrentTime.prototype = Object.create(Component.prototype);
  CurrentTime.prototype.constructor = CurrentTime;
  return CurrentTime;
});
