/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/hvac/Sequence
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:Sequence` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/hvac/Sequence}
   */

  var Sequence = function Sequence() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out[A-J]$': 'facets'
    });
  };

  Sequence.prototype = Object.create(Component.prototype);
  Sequence.prototype.constructor = Sequence;
  return Sequence;
});
