/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/hvac/LeadLagCycles
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:LeadLagCycles` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/hvac/LeadLagCycles}
   */

  var LeadLagCycles = function LeadLagCycles() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out[A-J]$': 'facets'
    });
  };

  LeadLagCycles.prototype = Object.create(Component.prototype);
  LeadLagCycles.prototype.constructor = LeadLagCycles;
  return LeadLagCycles;
});
