/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/energy/SlidingWindowDemandCalc
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:SlidingWindowDemandCalc` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/energy/SlidingWindowDemandCalc}
   */

  var SlidingWindowDemandCalc = function SlidingWindowDemandCalc() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^kwh(|Daily|Hourly|Last(Day|Hour))$': 'consumptionFacets',
      '^demand(\\d+)$': 'demandFacets',
      '^kwhPerPulse$': 'kwhPerPulseFacets'
    });
  };

  SlidingWindowDemandCalc.prototype = Object.create(Component.prototype);
  SlidingWindowDemandCalc.prototype.constructor = SlidingWindowDemandCalc;
  return SlidingWindowDemandCalc;
});
