/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/energy/SetpointLoadShed
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:SetpointLoadShed` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/energy/SetpointLoadShed}
   */

  var SetpointLoadShed = function SetpointLoadShed() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^((clg|htg)Offset|setpointIn)$': 'temperatureFacets'
    });
  };

  SetpointLoadShed.prototype = Object.create(Component.prototype);
  SetpointLoadShed.prototype.constructor = SetpointLoadShed;
  return SetpointLoadShed;
});
