/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/energy/NightPurge
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:NightPurge` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/energy/NightPurge}
   */

  var NightPurge = function NightPurge() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^((in|out)sideTemp|nightSetpoint|setpointDeadband|lowTemperatureLimit)$': 'temperatureFacets',
      '^(in|out)sideHumidity$': 'humidityFacets'
    });
  };

  NightPurge.prototype = Object.create(Component.prototype);
  NightPurge.prototype.constructor = NightPurge;
  return NightPurge;
});
