/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/energy/DegreeDays
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:DegreeDays` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/energy/DegreeDays}
   */

  var DegreeDays = function DegreeDays() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^(tempIn|(mean|max|min)Temp|baseTemperature)$': 'facets'
    });
  };

  DegreeDays.prototype = Object.create(Component.prototype);
  DegreeDays.prototype.constructor = DegreeDays;
  return DegreeDays;
});
