/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StringToStatusString
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StringToStatusString` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StringToStatusString}
   */

  var StringToStatusString = function StringToStatusString() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  StringToStatusString.prototype = Object.create(Component.prototype);
  StringToStatusString.prototype.constructor = StringToStatusString;
  return StringToStatusString;
});
