/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusValueToValue
 */
define(['baja!'], function (baja) {
  'use strict';

  var Component = baja.Component;
  /**
   * BajaScript representation of a `kitControl:StatusValueToValue` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   */

  var StatusValueToValue = function StatusValueToValue() {
    Component.apply(this, arguments);
  };

  StatusValueToValue.prototype = Object.create(Component.prototype);
  StatusValueToValue.prototype.constructor = StatusValueToValue;
  /**
   * Should be overridden by subclasses.
   *
   * @abstract
   * @returns {baja.Facets}
   */

  StatusValueToValue.prototype.getOutFacets = function () {
    throw new Error('getOutFacets() not implemented');
  };
  /**
   * For `outValueOnNull`, return the result of `getOutFacets()`.
   *
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */


  StatusValueToValue.prototype.getFacets = function (slot) {
    switch (String(slot)) {
      case 'outValueOnNull':
        return this.getOutFacets();
    }

    return Component.prototype.getFacets.apply(this, arguments);
  };

  return StatusValueToValue;
});
