/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusStringToStatusNumeric
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StatusStringToStatusNumeric` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusStringToStatusNumeric}
   */

  var StatusStringToStatusNumeric = function StatusStringToStatusNumeric() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  StatusStringToStatusNumeric.prototype = Object.create(Component.prototype);
  StatusStringToStatusNumeric.prototype.constructor = StatusStringToStatusNumeric;
  return StatusStringToStatusNumeric;
});
