/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusNumericToStatusEnum
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StatusNumericToStatusEnum` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusNumericToStatusEnum}
   */

  var StatusNumericToStatusEnum = function StatusNumericToStatusEnum() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  StatusNumericToStatusEnum.prototype = Object.create(Component.prototype);
  StatusNumericToStatusEnum.prototype.constructor = StatusNumericToStatusEnum;
  return StatusNumericToStatusEnum;
});
