/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusNumericToFloat
 */
define(['baja!', 'nmodule/kitControl/rc/baja/conversion/StatusValueToValue', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, StatusValueToValue, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StatusNumericToFloat` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusNumericToFloat}
   */

  var StatusNumericToFloat = function StatusNumericToFloat() {
    StatusValueToValue.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  StatusNumericToFloat.prototype = Object.create(StatusValueToValue.prototype);
  StatusNumericToFloat.prototype.constructor = StatusNumericToFloat;
  /**
   * Return the value of the `facets` slot.
   *
   * @returns {baja.Facets}
   */

  StatusNumericToFloat.prototype.getOutFacets = function () {
    return this.get('facets');
  };

  return StatusNumericToFloat;
});
