/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusEnumToStatusBoolean
 */
define(['baja!'], function (baja) {
  'use strict';

  var Component = baja.Component;
  /**
   * BajaScript representation of a `kitControl:StatusEnumToStatusBoolean` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusEnumToStatusBoolean}
   */

  var StatusEnumToStatusBoolean = function StatusEnumToStatusBoolean() {
    Component.apply(this, arguments);
  };

  StatusEnumToStatusBoolean.prototype = Object.create(Component.prototype);
  StatusEnumToStatusBoolean.prototype.constructor = StatusEnumToStatusBoolean;
  /**
   * Swap in `inFacets`/`outFacets` for the `in` and `out` slots, or merge in
   * `inFacets` to the existing facets for the `activeValues` slot.
   *
   * @param {String|baja.Slot} slot
   * @returns {baja.Facets}
   */

  StatusEnumToStatusBoolean.prototype.getFacets = function (slot) {
    var slotName = String(slot);

    switch (slotName) {
      case 'in':
        return this.get('inFacets');

      case 'out':
        return this.get('outFacets');
    }

    var facets = Component.prototype.getFacets.apply(this, arguments);

    if (slotName === 'activeValues') {
      return baja.Facets.make(this.get('inFacets'), facets);
    } else {
      return facets;
    }
  };

  return StatusEnumToStatusBoolean;
});
