/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusEnumToEnum
 */
define(['baja!', 'nmodule/kitControl/rc/baja/conversion/StatusValueToValue', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, StatusValueToValue, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StatusEnumToEnum` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusEnumToEnum}
   */

  var StatusEnumToEnum = function StatusEnumToEnum() {
    StatusValueToValue.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  StatusEnumToEnum.prototype = Object.create(StatusValueToValue.prototype);
  StatusEnumToEnum.prototype.constructor = StatusEnumToEnum;
  /**
   * Return the value of the `facets` slot.
   *
   * @returns {baja.Facets}
   */

  StatusEnumToEnum.prototype.getOutFacets = function () {
    return this.get('facets');
  };

  return StatusEnumToEnum;
});
