/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/StatusBooleanToBoolean
 */
define(['baja!', 'nmodule/kitControl/rc/baja/conversion/StatusValueToValue', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, StatusValueToValue, bajaUtils) {
  'use strict';

  var proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:StatusBooleanToBoolean` value.
   *
   * @class
   * @extends {module:nmodule/kitControl/rc/baja/conversion/StatusValueToValue}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/StatusBooleanToBoolean}
   */

  var StatusBooleanToBoolean = function StatusBooleanToBoolean() {
    StatusValueToValue.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  StatusBooleanToBoolean.prototype = Object.create(StatusValueToValue.prototype);
  StatusBooleanToBoolean.prototype.constructor = StatusBooleanToBoolean;
  /**
   * Return the value of the `facets` slot.
   *
   * @returns {baja.Facets}
   */

  StatusBooleanToBoolean.prototype.getOutFacets = function () {
    return this.get('facets');
  };

  return StatusBooleanToBoolean;
});
