/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/LongToStatusNumeric
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:LongToStatusNumeric` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/LongToStatusNumeric}
   */

  var LongToStatusNumeric = function LongToStatusNumeric() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  LongToStatusNumeric.prototype = Object.create(Component.prototype);
  LongToStatusNumeric.prototype.constructor = LongToStatusNumeric;
  return LongToStatusNumeric;
});
