/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/EnumToStatusEnum
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:EnumToStatusEnum` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/EnumToStatusEnum}
   */

  var EnumToStatusEnum = function EnumToStatusEnum() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  EnumToStatusEnum.prototype = Object.create(Component.prototype);
  EnumToStatusEnum.prototype.constructor = EnumToStatusEnum;
  return EnumToStatusEnum;
});
