/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/DoubleToStatusNumeric
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:DoubleToStatusNumeric` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/DoubleToStatusNumeric}
   */

  var DoubleToStatusNumeric = function DoubleToStatusNumeric() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  DoubleToStatusNumeric.prototype = Object.create(Component.prototype);
  DoubleToStatusNumeric.prototype.constructor = DoubleToStatusNumeric;
  return DoubleToStatusNumeric;
});
