/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/kitControl/rc/baja/conversion/BooleanToStatusBoolean
 */
define(['baja!', 'nmodule/webEditors/rc/baja/bajaUtils'], function (baja, bajaUtils) {
  'use strict';

  var Component = baja.Component,
      proxySlotFacets = bajaUtils.proxySlotFacets;
  /**
   * BajaScript representation of a `kitControl:BooleanToStatusBoolean` value.
   *
   * @class
   * @extends {baja.Component}
   * @alias {module:nmodule/kitControl/rc/baja/conversion/BooleanToStatusBoolean}
   */

  var BooleanToStatusBoolean = function BooleanToStatusBoolean() {
    Component.apply(this, arguments);
    proxySlotFacets(this, {
      '^out$': 'facets'
    });
  };

  BooleanToStatusBoolean.prototype = Object.create(Component.prototype);
  BooleanToStatusBoolean.prototype.constructor = BooleanToStatusBoolean;
  return BooleanToStatusBoolean;
});
